/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.components;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import util.FileUtil;

public class ContentBuffer {
    private File tempFile;
    private OutputStream outputStream;
    private boolean opened;
    private int size = 0;

    public ContentBuffer() throws IOException {
        this(".tmp");
    }

    public ContentBuffer(String ext) throws IOException {
        this.tempFile = File.createTempFile("FitNesse-", ext);
    }

    private void open() throws FileNotFoundException {
        if (!this.opened) {
            this.outputStream = new FileOutputStream(this.tempFile, true);
            this.opened = true;
        }
    }

    public ContentBuffer append(String value) throws IOException {
        byte[] bytes = value.getBytes("UTF-8");
        return this.append(bytes);
    }

    public ContentBuffer append(byte[] bytes) throws IOException {
        this.open();
        this.size += bytes.length;
        this.outputStream.write(bytes);
        return this;
    }

    private void close() throws IOException {
        if (this.opened) {
            this.outputStream.close();
            this.opened = false;
        }
    }

    public String getContent() throws IOException {
        this.close();
        return FileUtil.getFileContent(this.tempFile);
    }

    public int getSize() {
        return this.size;
    }

    public InputStream getInputStream() throws IOException {
        this.close();
        return new FileInputStream(this.tempFile){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    ContentBuffer.this.tempFile.delete();
                }
            }
        };
    }

    public InputStream getNonDeleteingInputStream() throws IOException {
        this.close();
        return new FileInputStream(this.tempFile);
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    protected File getFile() {
        return this.tempFile;
    }

    public void delete() {
        this.tempFile.delete();
    }

    protected void finalize() throws Throwable {
        this.delete();
        super.finalize();
    }
}

