/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.IndexShardComponent;
import org.elasticsearch.index.shard.ShardId;

public abstract class AbstractIndexShardComponent
implements IndexShardComponent {
    protected final ESLogger logger;
    protected final ShardId shardId;
    protected final Settings indexSettings;
    protected final Settings componentSettings;

    protected AbstractIndexShardComponent(ShardId shardId, @IndexSettings Settings indexSettings) {
        this.shardId = shardId;
        this.indexSettings = indexSettings;
        this.componentSettings = indexSettings.getComponentSettings(this.getClass());
        this.logger = Loggers.getLogger(this.getClass(), indexSettings, shardId, new String[0]);
    }

    protected AbstractIndexShardComponent(ShardId shardId, @IndexSettings Settings indexSettings, String prefixSettings) {
        this.shardId = shardId;
        this.indexSettings = indexSettings;
        this.componentSettings = indexSettings.getComponentSettings(prefixSettings, this.getClass());
        this.logger = Loggers.getLogger(this.getClass(), indexSettings, shardId, new String[0]);
    }

    @Override
    public ShardId shardId() {
        return this.shardId;
    }

    @Override
    public Settings indexSettings() {
        return this.indexSettings;
    }

    public String nodeName() {
        return this.indexSettings.get("name", "");
    }
}

