package com.xebialabs.xltest.utils.glob;

import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

/**
 * Expects normalized (*NIX) paths
 *
 */
public class FileMatcher {
    private final static Logger LOG = LoggerFactory.getLogger(FileMatcher.class);

    private final String pattern;

    private AntPathMatcher pathMatcher = new AntPathMatcher();

    public FileMatcher(String pattern) {
        Preconditions.checkNotNull(pattern, "A Ant style pattern is required");
        this.pattern = pattern;
    }

    public boolean match(String filePath) {
        boolean result = pathMatcher.match(pattern, filePath);
        LOG.trace("Trying to match " + filePath + " with pattern " + pattern + ", match result is " + result);
        return result;
    }
}
