package com.xebialabs.xltest.serialize;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONWriter;
import org.springframework.stereotype.Component;

import com.xebialabs.xltest.domain.TestSpecification;

@Component
@Provider
@Produces({MediaType.APPLICATION_JSON})
public class ListOfTestSpecificationsWriter extends BasicMessageBodyWriter<List<TestSpecification>> {

    @Override
    public boolean isWriteable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        if (type == null) {
            return true;
        }
        Type containedType = ((ParameterizedType) type).getActualTypeArguments()[0];
        return TestSpecification.class.isAssignableFrom(containedType.getClass());
    }

    protected void writeJson(final List<TestSpecification> testSpecifications, final JSONWriter writer) throws JSONException {
        writer.array();
        for (TestSpecification testSpecification : testSpecifications) {
            writeJson(testSpecification, writer);
        }
        writer.endArray();
    }

    protected void writeJson(final TestSpecification testSpecification, final JSONWriter writer) throws JSONException {
        writer.object();
        writer.key("id").value(testSpecification.getId());
        writer.key("name").value(testSpecification.getName());
        writer.key("testToolName").value(testSpecification.getTestToolName());
        writer.key("searchPattern").value(testSpecification.getSearchPattern());
        writer.endObject();
    }

}
