/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.HasAggregations;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;

public class OrderPath {
    private static final String AGG_DELIM = ">";
    public final Token[] tokens;

    public static OrderPath parse(String path) {
        String[] elements = Strings.tokenizeToStringArray(path, AGG_DELIM);
        Token[] tokens = new Token[elements.length];
        String[] tuple = new String[2];
        for (int i = 0; i < elements.length; ++i) {
            int index;
            String element = elements[i];
            if (i == elements.length - 1) {
                index = element.lastIndexOf(91);
                if (index >= 0) {
                    if (index == 0 || index > element.length() - 3) {
                        throw new AggregationExecutionException("Invalid path element [" + element + "] in path [" + path + "]");
                    }
                    if (element.charAt(element.length() - 1) != ']') {
                        throw new AggregationExecutionException("Invalid path element [" + element + "] in path [" + path + "]");
                    }
                    tokens[i] = new Token(element, element.substring(0, index), element.substring(index + 1, element.length() - 1));
                    continue;
                }
                index = element.lastIndexOf(46);
                if (index < 0) {
                    tokens[i] = new Token(element, element, null);
                    continue;
                }
                if (index == 0 || index > element.length() - 2) {
                    throw new AggregationExecutionException("Invalid path element [" + element + "] in path [" + path + "]");
                }
                tuple = OrderPath.split(element, index, tuple);
                tokens[i] = new Token(element, tuple[0], tuple[1]);
                continue;
            }
            index = element.lastIndexOf(91);
            if (index >= 0) {
                if (index == 0 || index > element.length() - 3) {
                    throw new AggregationExecutionException("Invalid path element [" + element + "] in path [" + path + "]");
                }
                if (element.charAt(element.length() - 1) != ']') {
                    throw new AggregationExecutionException("Invalid path element [" + element + "] in path [" + path + "]");
                }
                tokens[i] = new Token(element, element.substring(0, index), element.substring(index + 1, element.length() - 1));
                continue;
            }
            tokens[i] = new Token(element, element, null);
        }
        return new OrderPath(tokens);
    }

    public OrderPath(Token[] tokens) {
        this.tokens = tokens;
        if (tokens == null || tokens.length == 0) {
            throw new ElasticsearchIllegalArgumentException("Invalid path [" + this + "]");
        }
    }

    public String toString() {
        return Strings.arrayToDelimitedString(this.tokens, AGG_DELIM);
    }

    public Token lastToken() {
        return this.tokens[this.tokens.length - 1];
    }

    public OrderPath subPath(int offset, int length) {
        Token[] subTokens = new Token[length];
        System.arraycopy(this.tokens, offset, subTokens, 0, length);
        return new OrderPath(this.tokens);
    }

    public double resolveValue(HasAggregations root) {
        HasAggregations parent = root;
        double value = Double.NaN;
        for (int i = 0; i < this.tokens.length; ++i) {
            Token token = this.tokens[i];
            Object agg = parent.getAggregations().get(token.name);
            if (agg == null) {
                throw new ElasticsearchIllegalArgumentException("Invalid order path [" + this + "]. Cannot find aggregation named [" + token.name + "]");
            }
            if (agg instanceof SingleBucketAggregation) {
                if (token.key != null && !token.key.equals("doc_count")) {
                    throw new ElasticsearchIllegalArgumentException("Invalid order path [" + this + "]. Unknown value key [" + token.key + "] for single-bucket aggregation [" + token.name + "]. Either use [doc_count] as key or drop the key all together");
                }
                parent = (SingleBucketAggregation)agg;
                value = ((SingleBucketAggregation)agg).getDocCount();
                continue;
            }
            if (i != this.tokens.length - 1) {
                throw new ElasticsearchIllegalArgumentException("Invalid order path [" + this + "]. Metrics aggregations cannot have sub-aggregations (at [" + token + AGG_DELIM + this.tokens[i + 1] + "]");
            }
            if (agg instanceof InternalNumericMetricsAggregation.SingleValue) {
                if (token.key != null && !token.key.equals("value")) {
                    throw new ElasticsearchIllegalArgumentException("Invalid order path [" + this + "]. Unknown value key [" + token.key + "] for single-value metric aggregation [" + token.name + "]. Either use [value] as key or drop the key all together");
                }
                parent = null;
                value = ((InternalNumericMetricsAggregation.SingleValue)agg).value();
                continue;
            }
            if (token.key == null) {
                throw new ElasticsearchIllegalArgumentException("Invalid order path [" + this + "]. Missing value key in [" + token + "] which refers to a multi-value metric aggregation");
            }
            parent = null;
            value = ((InternalNumericMetricsAggregation.MultiValue)agg).value(token.key);
        }
        return value;
    }

    public Aggregator resolveAggregator(Aggregator root, boolean validate) {
        if (validate) {
            this.validate(root);
        }
        Aggregator aggregator = root;
        for (int i = 0; i < this.tokens.length; ++i) {
            Token token = this.tokens[i];
            aggregator = aggregator.subAggregator(token.name);
            assert (aggregator instanceof SingleBucketAggregator && i <= this.tokens.length - 1 || aggregator instanceof NumericMetricsAggregator && i == this.tokens.length - 1) : "this should be picked up before aggregation execution - on validate";
        }
        return aggregator;
    }

    public Aggregator resolveTopmostAggregator(Aggregator root, boolean validate) {
        if (validate) {
            this.validate(root);
        }
        Token token = this.tokens[0];
        Aggregator aggregator = root.subAggregator(token.name);
        assert (aggregator instanceof SingleBucketAggregator || aggregator instanceof NumericMetricsAggregator) : "this should be picked up before aggregation execution - on validate";
        return aggregator;
    }

    public void validate(Aggregator root) {
        Aggregator aggregator = root;
        for (int i = 0; i < this.tokens.length; ++i) {
            if ((aggregator = aggregator.subAggregator(this.tokens[i].name)) == null) {
                throw new AggregationExecutionException("Invalid term-aggregator order path [" + this + "]. Unknown aggregation [" + this.tokens[i].name + "]");
            }
            if (i >= this.tokens.length - 1) continue;
            if (!(aggregator instanceof SingleBucketAggregator)) {
                throw new AggregationExecutionException("Invalid terms aggregation order path [" + this + "]. Terms buckets can only be sorted on a sub-aggregator path " + "that is built out of zero or more single-bucket aggregations within the path and a final " + "single-bucket or a metrics aggregation at the path end. Sub-path [" + this.subPath(0, i + 1) + "] points to non single-bucket aggregation");
            }
            if (this.tokens[i].key == null) continue;
            throw new AggregationExecutionException("Invalid terms aggregation order path [" + this + "]. Terms buckets can only be sorted on a sub-aggregator path " + "that is built out of zero or more single-bucket aggregations within the path and a " + "final single-bucket or a metrics aggregation at the path end. Sub-path [" + this.subPath(0, i + 1) + "] points to non single-bucket aggregation");
        }
        boolean singleBucket = aggregator instanceof SingleBucketAggregator;
        if (!singleBucket && !(aggregator instanceof NumericMetricsAggregator)) {
            throw new AggregationExecutionException("Invalid terms aggregation order path [" + this + "]. Terms buckets can only be sorted on a sub-aggregator path " + "that is built out of zero or more single-bucket aggregations within the path and a final " + "single-bucket or a metrics aggregation at the path end.");
        }
        Token lastToken = this.lastToken();
        if (singleBucket) {
            if (lastToken.key != null && !"doc_count".equals(lastToken.key)) {
                throw new AggregationExecutionException("Invalid terms aggregation order path [" + this + "]. Ordering on a single-bucket aggregation can only be done on its doc_count. " + "Either drop the key (a la \"" + lastToken.name + "\") or change it to \"doc_count\" (a la \"" + lastToken.name + ".doc_count\")");
            }
            return;
        }
        if (aggregator instanceof NumericMetricsAggregator.SingleValue) {
            if (lastToken.key != null && !"value".equals(lastToken.key)) {
                throw new AggregationExecutionException("Invalid terms aggregation order path [" + this + "]. Ordering on a single-value metrics aggregation can only be done on its value. " + "Either drop the key (a la \"" + lastToken.name + "\") or change it to \"value\" (a la \"" + lastToken.name + ".value\")");
            }
            return;
        }
        if (lastToken.key == null) {
            throw new AggregationExecutionException("Invalid terms aggregation order path [" + this + "]. When ordering on a multi-value metrics aggregation a metric name must be specified");
        }
        if (!((NumericMetricsAggregator.MultiValue)aggregator).hasMetric(lastToken.key)) {
            throw new AggregationExecutionException("Invalid terms aggregation order path [" + this + "]. Unknown metric name [" + lastToken.key + "] on multi-value metrics aggregation [" + lastToken.name + "]");
        }
    }

    private static String[] split(String toSplit, int index, String[] result) {
        result[0] = toSplit.substring(0, index);
        result[1] = toSplit.substring(index + 1);
        return result;
    }

    public static class Token {
        private final String fullName;
        public final String name;
        public final String key;

        public Token(String fullName, String name, String key) {
            this.fullName = fullName;
            this.name = name;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Token token = (Token)o;
            if (this.key != null ? !this.key.equals(token.key) : token.key != null) {
                return false;
            }
            return this.name.equals(token.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
            return result;
        }

        public String toString() {
            return this.fullName;
        }
    }
}

