/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.packed.AppendingPackedLongBuffer;
import org.apache.lucene.util.packed.MonotonicAppendingLongBuffer;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;

public class MultiOrdinals
extends Ordinals {
    private static final int OFFSETS_PAGE_SIZE = 1024;
    private static final int OFFSET_INIT_PAGE_COUNT = 16;
    private final boolean multiValued;
    private final long maxOrd;
    private final MonotonicAppendingLongBuffer endOffsets;
    private final AppendingPackedLongBuffer ords;

    public static boolean significantlySmallerThanSinglePackedOrdinals(int maxDoc, int numDocsWithValue, long numOrds, float acceptableOverheadRatio) {
        int bitsPerOrd = PackedInts.bitsRequired((long)numOrds);
        bitsPerOrd = PackedInts.fastestFormatAndBits((int)numDocsWithValue, (int)bitsPerOrd, (float)acceptableOverheadRatio).bitsPerValue;
        float avgValuesPerDoc = (float)numDocsWithValue / (float)maxDoc;
        int maxDelta = (int)Math.ceil(1024.0f * (1.0f - avgValuesPerDoc) * avgValuesPerDoc);
        int bitsPerOffset = PackedInts.bitsRequired((long)maxDelta) + 1;
        bitsPerOffset = PackedInts.fastestFormatAndBits((int)maxDoc, (int)bitsPerOffset, (float)acceptableOverheadRatio).bitsPerValue;
        long expectedMultiSizeInBytes = (long)numDocsWithValue * (long)bitsPerOrd + (long)maxDoc * (long)bitsPerOffset;
        long expectedSingleSizeInBytes = (long)maxDoc * (long)bitsPerOrd;
        return (float)expectedMultiSizeInBytes < 0.8f * (float)expectedSingleSizeInBytes;
    }

    public MultiOrdinals(OrdinalsBuilder builder, float acceptableOverheadRatio) {
        this.multiValued = builder.getNumMultiValuesDocs() > 0;
        this.maxOrd = builder.getMaxOrd();
        this.endOffsets = new MonotonicAppendingLongBuffer(16, 1024, acceptableOverheadRatio);
        this.ords = new AppendingPackedLongBuffer(16, 1024, acceptableOverheadRatio);
        long lastEndOffset = 0L;
        for (int i = 0; i < builder.maxDoc(); ++i) {
            LongsRef docOrds = builder.docOrds(i);
            long endOffset = lastEndOffset + (long)docOrds.length;
            this.endOffsets.add(endOffset);
            for (int j = 0; j < docOrds.length; ++j) {
                this.ords.add(docOrds.longs[docOrds.offset + j]);
            }
            lastEndOffset = endOffset;
        }
        assert (this.endOffsets.size() == (long)builder.maxDoc());
        assert (this.ords.size() == (long)builder.getTotalNumOrds()) : this.ords.size() + " != " + builder.getTotalNumOrds();
    }

    @Override
    public long ramBytesUsed() {
        return this.endOffsets.ramBytesUsed() + this.ords.ramBytesUsed();
    }

    @Override
    public BytesValues.WithOrdinals ordinals(Ordinals.ValuesHolder values) {
        return new MultiDocs(this, values);
    }

    public static class MultiDocs
    extends BytesValues.WithOrdinals {
        private final long maxOrd;
        private final MonotonicAppendingLongBuffer endOffsets;
        private final AppendingPackedLongBuffer ords;
        private long offset;
        private long limit;
        private final Ordinals.ValuesHolder values;

        MultiDocs(MultiOrdinals ordinals, Ordinals.ValuesHolder values) {
            super(ordinals.multiValued);
            this.maxOrd = ordinals.maxOrd;
            this.endOffsets = ordinals.endOffsets;
            this.ords = ordinals.ords;
            this.values = values;
        }

        @Override
        public long getMaxOrd() {
            return this.maxOrd;
        }

        @Override
        public long getOrd(int docId) {
            long endOffset;
            long startOffset = docId > 0 ? this.endOffsets.get(docId - 1) : 0L;
            if (startOffset == (endOffset = this.endOffsets.get(docId))) {
                return -1L;
            }
            return this.ords.get(startOffset);
        }

        @Override
        public long nextOrd() {
            assert (this.offset < this.limit);
            return this.ords.get(this.offset++);
        }

        @Override
        public int setDocument(int docId) {
            long startOffset = docId > 0 ? this.endOffsets.get(docId - 1) : 0L;
            long endOffset = this.endOffsets.get(docId);
            this.offset = startOffset;
            this.limit = endOffset;
            return (int)(endOffset - startOffset);
        }

        @Override
        public BytesRef getValueByOrd(long ord) {
            return this.values.getValueByOrd(ord);
        }
    }
}

