/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Parser;
import fitnesse.wikitext.parser.Rule;
import fitnesse.wikitext.parser.Symbol;
import fitnesse.wikitext.parser.SymbolType;
import util.Maybe;

public class ListRule
implements Rule {
    @Override
    public Maybe<Symbol> parse(Symbol current, Parser parser) {
        return this.populateList(parser, current);
    }

    private Maybe<Symbol> populateList(Parser parser, Symbol list) {
        Symbol nextSymbol = list;
        while (ListRule.isList(nextSymbol) && this.indent(nextSymbol) >= this.indent(list)) {
            if (nextSymbol != list) {
                parser.moveNext(1);
            }
            if (this.indent(nextSymbol) > this.indent(list)) {
                Maybe<Symbol> subList = this.populateList(parser, nextSymbol);
                if (subList.isNothing()) {
                    return Symbol.nothing;
                }
                list.lastChild().add(subList.getValue());
            } else {
                Symbol body = this.makeListBody(parser);
                if (parser.atEnd()) {
                    return Symbol.nothing;
                }
                list.add(body);
            }
            nextSymbol = parser.peek();
        }
        return new Maybe<Symbol>(list);
    }

    private static boolean isList(Symbol symbol) {
        return symbol.isType(SymbolType.OrderedList) || symbol.isType(SymbolType.UnorderedList);
    }

    private Symbol makeListBody(Parser parser) {
        while (parser.peek(new SymbolType[]{SymbolType.Whitespace}).size() > 0) {
            parser.moveNext(1);
        }
        return parser.parseTo(SymbolType.Newline, 1);
    }

    private int indent(Symbol symbol) {
        String content = symbol.getContent();
        int result = 0;
        while (Character.isWhitespace(content.charAt(result))) {
            ++result;
        }
        return result;
    }
}

