/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.JackrabbitTermQuery;
import org.apache.jackrabbit.core.query.lucene.LazyTextExtractorField;
import org.apache.jackrabbit.core.query.lucene.MatchAllQuery;
import org.apache.jackrabbit.core.query.lucene.PerQueryCache;
import org.apache.jackrabbit.core.query.lucene.ReleaseableIndexReader;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger log = LoggerFactory.getLogger(Util.class);

    public static void disposeDocument(Document old) {
        for (Fieldable f : old.getFields()) {
            try {
                if (f.readerValue() != null) {
                    f.readerValue().close();
                    continue;
                }
                if (!(f instanceof LazyTextExtractorField)) continue;
                LazyTextExtractorField field = (LazyTextExtractorField)f;
                field.dispose();
            }
            catch (IOException ex) {
                log.warn("Exception while disposing index document: " + ex);
            }
        }
    }

    public static boolean isDocumentReady(Document doc) {
        for (Fieldable f : doc.getFields()) {
            LazyTextExtractorField field;
            if (!(f instanceof LazyTextExtractorField) || (field = (LazyTextExtractorField)f).isExtractorFinished()) continue;
            return false;
        }
        return true;
    }

    public static Query createMatchAllQuery(String name, IndexFormatVersion version, PerQueryCache cache) {
        if (version.getVersion() >= IndexFormatVersion.V2.getVersion()) {
            return new JackrabbitTermQuery(new Term(FieldNames.PROPERTIES_SET, name));
        }
        return new MatchAllQuery(name, cache);
    }

    public static IOException createIOException(Throwable t) {
        IOException ex = new IOException(t.getMessage());
        ex.initCause(t);
        return ex;
    }

    public static void closeOrRelease(IndexReader reader) throws IOException {
        if (reader instanceof ReleaseableIndexReader) {
            ((ReleaseableIndexReader)reader).release();
        } else {
            reader.close();
        }
    }

    public static Comparable getComparable(InternalValue value) throws RepositoryException {
        switch (value.getType()) {
            case 2: {
                return null;
            }
            case 6: {
                return Boolean.valueOf(value.getBoolean());
            }
            case 5: {
                return Long.valueOf(value.getDate().getTimeInMillis());
            }
            case 4: {
                return Double.valueOf(value.getDouble());
            }
            case 3: {
                return Long.valueOf(value.getLong());
            }
            case 12: {
                return value.getDecimal();
            }
            case 7: {
                return value.getName().toString();
            }
            case 8: {
                return value.getPath().toString();
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: {
                return value.getString();
            }
        }
        return null;
    }

    public static Comparable getComparable(Value value) throws ValueFormatException, RepositoryException {
        switch (value.getType()) {
            case 6: {
                return Boolean.valueOf(value.getBoolean());
            }
            case 5: {
                return Long.valueOf(value.getDate().getTimeInMillis());
            }
            case 4: {
                return Double.valueOf(value.getDouble());
            }
            case 3: {
                return Long.valueOf(value.getLong());
            }
            case 12: {
                return value.getDecimal();
            }
            case 1: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return value.getString();
            }
        }
        throw new RepositoryException("Unsupported type: " + PropertyType.nameFromValue((int)value.getType()));
    }

    public static int compare(Comparable c1, Comparable c2) {
        if (c1 == c2) {
            return 0;
        }
        if (c1 == null) {
            return -1;
        }
        if (c2 == null) {
            return 1;
        }
        if (c1.getClass() == c2.getClass()) {
            return c1.compareTo(c2);
        }
        String name1 = c1.getClass().getName();
        String name2 = c2.getClass().getName();
        return name1.compareTo(name2);
    }

    public static int compare(Comparable<?>[] c1, Comparable<?>[] c2) {
        if (c1 == null && c2 == null) {
            return 0;
        }
        if (c1 == null) {
            return -1;
        }
        if (c2 == null) {
            return 1;
        }
        for (int i = 0; i < c1.length && i < c2.length; ++i) {
            int d = Util.compare(c1[i], c2[i]);
            if (d == 0) continue;
            return d;
        }
        return c1.length - c2.length;
    }

    public static int compare(Value[] a, Value[] b) throws RepositoryException {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        for (int i = 0; i < a.length && i < b.length; ++i) {
            int d = Util.compare(a[i], b[i]);
            if (d == 0) continue;
            return d;
        }
        return a.length - b.length;
    }

    public static int compare(Value v1, Value v2) throws ValueFormatException, RepositoryException {
        Object c2;
        Comparable c1 = Util.getComparable(v1);
        switch (v1.getType()) {
            case 6: {
                c2 = v2.getBoolean();
                break;
            }
            case 5: {
                c2 = v2.getDate().getTimeInMillis();
                break;
            }
            case 4: {
                c2 = v2.getDouble();
                break;
            }
            case 3: {
                c2 = v2.getLong();
                break;
            }
            case 12: {
                c2 = v2.getDecimal();
                break;
            }
            case 7: {
                if (v2.getType() == 11) {
                    String s = v2.getString();
                    if (s.startsWith("./")) {
                        s = s.substring(2);
                    }
                    try {
                        c2 = URLDecoder.decode(s, "UTF-8");
                        break;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RepositoryException((Throwable)e);
                    }
                }
                c2 = v2.getString();
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                c2 = v2.getString();
                break;
            }
            default: {
                throw new RepositoryException("Unsupported type: " + PropertyType.nameFromValue((int)v2.getType()));
            }
        }
        return Util.compare(c1, (Comparable)c2);
    }

    public static Pattern createRegexp(String likePattern) {
        StringBuffer regexp = new StringBuffer();
        boolean escaped = false;
        block4: for (int i = 0; i < likePattern.length(); ++i) {
            if (likePattern.charAt(i) == '\\') {
                if (escaped) {
                    regexp.append("\\\\");
                    escaped = false;
                    continue;
                }
                escaped = true;
                continue;
            }
            if (Character.isLetterOrDigit(likePattern.charAt(i))) {
                if (escaped) {
                    regexp.append("\\\\").append(likePattern.charAt(i));
                    escaped = false;
                    continue;
                }
                regexp.append(likePattern.charAt(i));
                continue;
            }
            if (escaped) {
                regexp.append('\\').append(likePattern.charAt(i));
                escaped = false;
                continue;
            }
            switch (likePattern.charAt(i)) {
                case '_': {
                    regexp.append('.');
                    continue block4;
                }
                case '%': {
                    regexp.append(".*");
                    continue block4;
                }
                default: {
                    regexp.append('\\').append(likePattern.charAt(i));
                }
            }
        }
        return Pattern.compile(regexp.toString(), 32);
    }

    public static long getLength(InternalValue value) {
        if (value.getType() == 7 || value.getType() == 8) {
            return -1L;
        }
        try {
            return value.getLength();
        }
        catch (RepositoryException e) {
            log.warn("Unable to determine length of value.", (Object)e.getMessage());
            return -1L;
        }
    }
}

