/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.crypto.tls.TlsUtils;

public class CertificateRequest {
    private short[] certificateTypes;
    private Vector certificateAuthorities;

    public CertificateRequest(short[] sArray, Vector vector) {
        this.certificateTypes = sArray;
        this.certificateAuthorities = vector;
    }

    public short[] getCertificateTypes() {
        return this.certificateTypes;
    }

    public Vector getCertificateAuthorities() {
        return this.certificateAuthorities;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (this.certificateTypes == null || this.certificateTypes.length == 0) {
            TlsUtils.writeUint8((short)0, outputStream);
        } else {
            TlsUtils.writeUint8((short)this.certificateTypes.length, outputStream);
            TlsUtils.writeUint8Array(this.certificateTypes, outputStream);
        }
        if (this.certificateAuthorities == null || this.certificateAuthorities.isEmpty()) {
            TlsUtils.writeUint16(0, outputStream);
        } else {
            Object object;
            int n;
            Vector<byte[]> vector = new Vector<byte[]>(this.certificateAuthorities.size());
            int n2 = 0;
            for (n = 0; n < this.certificateAuthorities.size(); ++n) {
                object = (X500Name)this.certificateAuthorities.elementAt(n);
                byte[] byArray = ((ASN1Object)object).getEncoded("DER");
                vector.addElement(byArray);
                n2 += byArray.length;
            }
            TlsUtils.writeUint16(n2, outputStream);
            for (n = 0; n < vector.size(); ++n) {
                object = (byte[])vector.elementAt(n);
                outputStream.write((byte[])object);
            }
        }
    }

    public static CertificateRequest parse(InputStream inputStream) throws IOException {
        int n = TlsUtils.readUint8(inputStream);
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = TlsUtils.readUint8(inputStream);
        }
        byte[] byArray = TlsUtils.readOpaque16(inputStream);
        Vector<X500Name> vector = new Vector<X500Name>();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        while (byteArrayInputStream.available() > 0) {
            byte[] byArray2 = TlsUtils.readOpaque16(byteArrayInputStream);
            vector.addElement(X500Name.getInstance(ASN1Primitive.fromByteArray(byArray2)));
        }
        return new CertificateRequest(sArray, vector);
    }
}

