/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.node;

import java.util.Map;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.admin.cluster.ClusterAction;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.client.support.AbstractClusterAdminClient;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.threadpool.ThreadPool;

public class NodeClusterAdminClient
extends AbstractClusterAdminClient
implements ClusterAdminClient {
    private final ThreadPool threadPool;
    private final ImmutableMap<ClusterAction, TransportAction> actions;

    @Inject
    public NodeClusterAdminClient(ThreadPool threadPool, Map<GenericAction, TransportAction> actions) {
        this.threadPool = threadPool;
        MapBuilder<ClusterAction, TransportAction> actionsBuilder = new MapBuilder<ClusterAction, TransportAction>();
        for (Map.Entry<GenericAction, TransportAction> entry : actions.entrySet()) {
            if (!(entry.getKey() instanceof ClusterAction)) continue;
            actionsBuilder.put((ClusterAction)entry.getKey(), entry.getValue());
        }
        this.actions = actionsBuilder.immutableMap();
    }

    @Override
    public ThreadPool threadPool() {
        return this.threadPool;
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, ClusterAdminClient>> ActionFuture<Response> execute(Action<Request, Response, RequestBuilder, ClusterAdminClient> action, Request request) {
        TransportAction transportAction = this.actions.get((ClusterAction)action);
        return transportAction.execute(request);
    }

    @Override
    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, ClusterAdminClient>> void execute(Action<Request, Response, RequestBuilder, ClusterAdminClient> action, Request request, ActionListener<Response> listener) {
        TransportAction transportAction = this.actions.get((ClusterAction)action);
        transportAction.execute(request, listener);
    }
}

