/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wikitext.parser;

import fitnesse.wikitext.parser.Alias;
import fitnesse.wikitext.parser.Link;
import fitnesse.wikitext.parser.Literal;
import fitnesse.wikitext.parser.Path;
import fitnesse.wikitext.parser.Preformat;
import fitnesse.wikitext.parser.SourcePage;
import fitnesse.wikitext.parser.SymbolType;
import fitnesse.wikitext.parser.Translation;
import fitnesse.wikitext.parser.Translator;
import fitnesse.wikitext.parser.Variable;
import fitnesse.wikitext.parser.WikiBuilder;
import java.util.HashMap;

public class WikiTranslator
extends Translator {
    private static final HashMap<SymbolType, Translation> translations = new HashMap();

    private static void addTranslation(SymbolType symbolType, Translation translation) {
        translations.put(symbolType, translation);
    }

    public WikiTranslator(SourcePage page) {
        super(page);
    }

    @Override
    protected Translation getTranslation(SymbolType symbolType) {
        return translations.get(symbolType);
    }

    static {
        WikiTranslator.addTranslation(Alias.symbolType, new WikiBuilder().text("[[").children("][").text("]]"));
        WikiTranslator.addTranslation(Link.symbolType, new WikiBuilder().property("image", "", "!img ").property("image", "left", "!img-l ").property("image", "right", "!img-r ").content().child(0));
        WikiTranslator.addTranslation(Literal.symbolType, new WikiBuilder().text("!-").content().text("-!"));
        WikiTranslator.addTranslation(Path.symbolType, new WikiBuilder().text("!path ").child(0));
        WikiTranslator.addTranslation(Preformat.symbolType, new WikiBuilder().text("{{{").child(0).text("}}}"));
        WikiTranslator.addTranslation(Variable.symbolType, new WikiBuilder().text("${").child(0).text("}"));
    }
}

