/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.transaction.compensating.support;

import java.util.List;
import javax.naming.Name;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapRdn;
import org.springframework.ldap.core.LdapRdnComponent;
import org.springframework.ldap.transaction.compensating.TempEntryRenamingStrategy;

public class DefaultTempEntryRenamingStrategy
implements TempEntryRenamingStrategy {
    public static final String DEFAULT_TEMP_SUFFIX = "_temp";
    private String tempSuffix = "_temp";

    public Name getTemporaryName(Name originalName) {
        DistinguishedName temporaryName = new DistinguishedName(originalName);
        List names = temporaryName.getNames();
        LdapRdn rdn = (LdapRdn)names.get(names.size() - 1);
        LdapRdnComponent rdnComponent = rdn.getComponent();
        String value = rdnComponent.getValue();
        rdnComponent.setValue(value + DEFAULT_TEMP_SUFFIX);
        return temporaryName;
    }

    public String getTempSuffix() {
        return this.tempSuffix;
    }

    public void setTempSuffix(String tempSuffix) {
        this.tempSuffix = tempSuffix;
    }
}

