/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.dfs;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.storage.dfs.DfsRepositoryDescription;
import org.eclipse.jgit.storage.pack.PackExt;
import org.eclipse.jgit.storage.pack.PackWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfsPackDescription
implements Comparable<DfsPackDescription> {
    private final DfsRepositoryDescription repoDesc;
    private final String packName;
    private DfsObjDatabase.PackSource packSource;
    private long lastModified;
    private Map<PackExt, Long> sizeMap;
    private long objectCount;
    private long deltaCount;
    private Set<ObjectId> tips;
    private PackWriter.Statistics stats;

    public DfsPackDescription(DfsRepositoryDescription repoDesc, String name) {
        this.repoDesc = repoDesc;
        int dot = name.lastIndexOf(46);
        this.packName = dot < 0 ? name : name.substring(0, dot);
        this.sizeMap = new HashMap<PackExt, Long>(5);
    }

    public DfsRepositoryDescription getRepositoryDescription() {
        return this.repoDesc;
    }

    public String getFileName(PackExt ext) {
        return this.packName + '.' + ext.getExtension();
    }

    public DfsObjDatabase.PackSource getPackSource() {
        return this.packSource;
    }

    public DfsPackDescription setPackSource(DfsObjDatabase.PackSource source) {
        this.packSource = source;
        return this;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public DfsPackDescription setLastModified(long timeMillis) {
        this.lastModified = timeMillis;
        return this;
    }

    public DfsPackDescription setFileSize(PackExt ext, long bytes) {
        this.sizeMap.put(ext, Math.max(0L, bytes));
        return this;
    }

    public long getFileSize(PackExt ext) {
        Long size = this.sizeMap.get(ext);
        return size == null ? 0L : size;
    }

    public long getObjectCount() {
        return this.objectCount;
    }

    public DfsPackDescription setObjectCount(long cnt) {
        this.objectCount = Math.max(0L, cnt);
        return this;
    }

    public long getDeltaCount() {
        return this.deltaCount;
    }

    public DfsPackDescription setDeltaCount(long cnt) {
        this.deltaCount = Math.max(0L, cnt);
        return this;
    }

    public Set<ObjectId> getTips() {
        return this.tips;
    }

    public DfsPackDescription setTips(Set<ObjectId> tips) {
        this.tips = tips;
        return this;
    }

    public PackWriter.Statistics getPackStats() {
        return this.stats;
    }

    DfsPackDescription setPackStats(PackWriter.Statistics stats) {
        this.stats = stats;
        return this;
    }

    public DfsPackDescription clearPackStats() {
        this.stats = null;
        return this;
    }

    public int hashCode() {
        return this.packName.hashCode();
    }

    public boolean equals(Object b) {
        if (b instanceof DfsPackDescription) {
            DfsPackDescription desc = (DfsPackDescription)b;
            return this.packName.equals(desc.packName) && this.getRepositoryDescription().equals(desc.getRepositoryDescription());
        }
        return false;
    }

    @Override
    public int compareTo(DfsPackDescription b) {
        int cmp = Long.signum(b.getLastModified() - this.getLastModified());
        if (cmp != 0) {
            return cmp;
        }
        return Long.signum(this.getObjectCount() - b.getObjectCount());
    }

    public String toString() {
        return this.getFileName(PackExt.PACK);
    }
}

