/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders.search;

import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.components.TraversalListener;
import fitnesse.http.Request;
import fitnesse.responders.search.ResultResponder;
import fitnesse.responders.search.SearchFormResponder;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageType;
import fitnesse.wiki.search.AttributeWikiPageFinder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExecuteSearchPropertiesResponder
extends ResultResponder {
    public static final String IGNORED = "Any";
    public static final String ACTION = "Action";
    public static final String SECURITY = "Security";
    public static final String SPECIAL = "Special";

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }

    protected List<PageType> getPageTypesFromInput(Request request) {
        String requestedPageTypes = (String)request.getInput("PageType");
        if (requestedPageTypes == null) {
            return null;
        }
        ArrayList<PageType> types = new ArrayList<PageType>();
        for (String type : requestedPageTypes.split(",")) {
            types.add(PageType.fromString(type));
        }
        return types;
    }

    protected String getSuitesFromInput(Request request) {
        if (!this.isSuitesGiven(request)) {
            return null;
        }
        return (String)request.getInput("Suites");
    }

    private boolean isSuitesGiven(Request request) {
        return request.hasInput("Suites");
    }

    protected Map<String, Boolean> getAttributesFromInput(Request request) {
        LinkedHashMap<String, Boolean> attributes = new LinkedHashMap<String, Boolean>();
        this.getListboxAttributesFromRequest(request, ACTION, SearchFormResponder.SEARCH_ACTION_ATTRIBUTES, attributes);
        this.getListboxAttributesFromRequest(request, SECURITY, PageData.SECURITY_ATTRIBUTES, attributes);
        this.getListboxAttributesFromRequest(request, SPECIAL, SearchFormResponder.SPECIAL_ATTRIBUTES, attributes);
        if (request.hasInput("Prune") || request.hasInput("obsolete")) {
            attributes.put("Prune", true);
        }
        return attributes;
    }

    private void getListboxAttributesFromRequest(Request request, String inputAttributeName, String[] attributeList, Map<String, Boolean> attributes) {
        String requested = (String)request.getInput(inputAttributeName);
        if (requested == null) {
            requested = IGNORED;
        }
        if (!IGNORED.equals(requested)) {
            for (String searchAttribute : attributeList) {
                attributes.put(searchAttribute, requested.contains(searchAttribute));
            }
        }
    }

    @Override
    protected String getTitle() {
        return "Search Page Properties Results";
    }

    @Override
    public void traverse(TraversalListener<Object> observer) {
        List<PageType> pageTypes = this.getPageTypesFromInput(this.request);
        Map<String, Boolean> attributes = this.getAttributesFromInput(this.request);
        String suites = this.getSuitesFromInput(this.request);
        if (pageTypes == null && attributes.isEmpty() && suites == null) {
            this.response.add("No search properties were specified.");
            return;
        }
        AttributeWikiPageFinder finder = new AttributeWikiPageFinder(observer, pageTypes, attributes, suites);
        finder.search(this.page);
    }
}

