/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.reporting.history;

import fitnesse.FitNesseVersion;
import fitnesse.reporting.history.SuiteExecutionReport;
import fitnesse.reporting.history.TestExecutionReport;
import fitnesse.testsystems.ExecutionResult;
import fitnesse.testsystems.TestSummary;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import util.DateTimeUtil;
import util.StringUtil;
import util.TimeMeasurement;
import util.XmlUtil;

public abstract class ExecutionReport {
    private String version;
    private String rootPath;
    private TestSummary finalCounts = new TestSummary(0, 0, 0, 0);
    public Date date;
    private long totalRunTimeInMillis = 0L;

    protected ExecutionReport() {
        this.version = new FitNesseVersion().toString();
    }

    public ExecutionReport(FitNesseVersion version, String rootPath) {
        this.version = version == null ? "null" : version.toString();
        this.rootPath = rootPath;
    }

    public void tallyPageCounts(ExecutionResult result) {
        this.finalCounts.tallyPageCounts(result);
    }

    public String toString() {
        return this.rootPath;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExecutionReport)) {
            return false;
        }
        ExecutionReport e = (ExecutionReport)o;
        if (!StringUtil.stringsNullOrEqual(this.rootPath, e.rootPath)) {
            return false;
        }
        if (!StringUtil.stringsNullOrEqual(this.version, e.version)) {
            return false;
        }
        if (!DateTimeUtil.datesNullOrEqual(this.date, e.date)) {
            return false;
        }
        if (!this.finalCounts.equals(e.finalCounts)) {
            return false;
        }
        return this.totalRunTimeInMillis == e.totalRunTimeInMillis;
    }

    public static ExecutionReport makeReport(String xmlString) throws Exception {
        Document xmlDocument = XmlUtil.newDocument(xmlString);
        Element documentElement = xmlDocument.getDocumentElement();
        String documentNodeName = documentElement.getNodeName();
        if (documentNodeName.equals("testResults")) {
            return new TestExecutionReport(xmlDocument);
        }
        if (documentNodeName.equals("suiteResults")) {
            return new SuiteExecutionReport(xmlDocument);
        }
        throw new RuntimeException(String.format("%s is not a valid document element tag for an Execution Report.", documentNodeName));
    }

    protected void unpackCommonFields(Element documentElement) {
        this.version = XmlUtil.getTextValue(documentElement, "FitNesseVersion");
        this.rootPath = XmlUtil.getTextValue(documentElement, "rootPath");
        String dateString = XmlUtil.getTextValue(documentElement, "date");
        if (dateString != null) {
            this.date = DateTimeUtil.getDateFromString(dateString);
        }
        this.unpackFinalCounts(documentElement);
        this.totalRunTimeInMillis = this.getTotalRunTimeInMillisOrZeroIfNotPresent(documentElement);
    }

    protected long getTotalRunTimeInMillisOrZeroIfNotPresent(Element documentElement) {
        String textValue = XmlUtil.getTextValue(documentElement, "totalRunTimeInMillis");
        return textValue == null ? 0L : Long.parseLong(textValue);
    }

    private void unpackFinalCounts(Element testResults) {
        Element counts = XmlUtil.getElementByTagName(testResults, "finalCounts");
        if (counts != null) {
            this.finalCounts = new TestSummary(Integer.parseInt(XmlUtil.getTextValue(counts, "right")), Integer.parseInt(XmlUtil.getTextValue(counts, "wrong")), Integer.parseInt(XmlUtil.getTextValue(counts, "ignores")), Integer.parseInt(XmlUtil.getTextValue(counts, "exceptions")));
        }
    }

    protected void unpackXml(Document xmlDoc) {
        Element historyDocument = xmlDoc.getDocumentElement();
        this.unpackCommonFields(historyDocument);
        this.unpackResults(historyDocument);
    }

    protected abstract void unpackResults(Element var1);

    public TestSummary getFinalCounts() {
        return this.finalCounts;
    }

    public String getVersion() {
        return this.version;
    }

    public long getTotalRunTimeInMillis() {
        return this.totalRunTimeInMillis;
    }

    public void setTotalRunTimeInMillis(TimeMeasurement totalTimeMeasurement) {
        this.totalRunTimeInMillis = totalTimeMeasurement.elapsed();
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public Date getDate() {
        return new Date(this.date.getTime());
    }

    public void setDate(Date date) {
        this.date = new Date(date.getTime());
    }

    public boolean hasRunTimes() {
        return new FitNesseVersion(this.getVersion()).isAtLeast("v20100607");
    }
}

