/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.util.FloatArray;
import org.elasticsearch.index.fielddata.AbstractAtomicNumericFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.DenseDoubleValues;
import org.elasticsearch.index.fielddata.plain.DenseLongValues;

public abstract class FloatArrayAtomicFieldData
extends AbstractAtomicNumericFieldData {
    protected long size = -1L;

    public static FloatArrayAtomicFieldData empty() {
        return new Empty();
    }

    public FloatArrayAtomicFieldData() {
        super(true);
    }

    @Override
    public void close() {
    }

    public static class Single
    extends FloatArrayAtomicFieldData {
        private final FloatArray values;

        public Single(FloatArray values) {
            this.values = values;
        }

        public long ramBytesUsed() {
            if (this.size == -1L) {
                this.size = (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.values.ramBytesUsed();
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values);
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values);
        }

        static class DoubleValues
        extends DenseDoubleValues {
            private final FloatArray values;

            DoubleValues(FloatArray values) {
                super(false);
                this.values = values;
            }

            @Override
            public double nextValue() {
                return this.values.get(this.docId);
            }
        }

        static class LongValues
        extends DenseLongValues {
            private final FloatArray values;

            LongValues(FloatArray values) {
                super(false);
                this.values = values;
            }

            @Override
            public long nextValue() {
                return (long)this.values.get(this.docId);
            }
        }
    }

    public static class SingleFixedSet
    extends FloatArrayAtomicFieldData {
        private final FloatArray values;
        private final FixedBitSet set;

        public SingleFixedSet(FloatArray values, FixedBitSet set) {
            this.values = values;
            this.set = set;
        }

        public long ramBytesUsed() {
            if (this.size == -1L) {
                this.size = (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.values.ramBytesUsed() + RamUsageEstimator.sizeOf((long[])this.set.getBits());
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values, this.set);
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values, this.set);
        }

        static class DoubleValues
        extends org.elasticsearch.index.fielddata.DoubleValues {
            private final FloatArray values;
            private final FixedBitSet set;

            DoubleValues(FloatArray values, FixedBitSet set) {
                super(false);
                this.values = values;
                this.set = set;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return this.set.get(docId) ? 1 : 0;
            }

            @Override
            public double nextValue() {
                return this.values.get(this.docId);
            }
        }

        static class LongValues
        extends org.elasticsearch.index.fielddata.LongValues {
            private final FloatArray values;
            private final FixedBitSet set;

            LongValues(FloatArray values, FixedBitSet set) {
                super(false);
                this.values = values;
                this.set = set;
            }

            @Override
            public int setDocument(int docId) {
                this.docId = docId;
                return this.set.get(docId) ? 1 : 0;
            }

            @Override
            public long nextValue() {
                return (long)this.values.get(this.docId);
            }
        }
    }

    public static class WithOrdinals
    extends FloatArrayAtomicFieldData {
        private final Ordinals ordinals;
        private final FloatArray values;

        public WithOrdinals(FloatArray values, Ordinals ordinals) {
            this.values = values;
            this.ordinals = ordinals;
        }

        public long ramBytesUsed() {
            if (this.size == -1L) {
                this.size = 4L + this.values.ramBytesUsed() + this.ordinals.ramBytesUsed();
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values, this.ordinals.ordinals());
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values, this.ordinals.ordinals());
        }

        static class DoubleValues
        extends DoubleValues.WithOrdinals {
            private final FloatArray values;

            DoubleValues(FloatArray values, BytesValues.WithOrdinals ordinals) {
                super(ordinals);
                this.values = values;
            }

            @Override
            public double getValueByOrd(long ord) {
                return this.values.get(ord);
            }
        }

        static class LongValues
        extends LongValues.WithOrdinals {
            private final FloatArray values;

            LongValues(FloatArray values, BytesValues.WithOrdinals ordinals) {
                super(ordinals);
                this.values = values;
            }

            @Override
            public long getValueByOrd(long ord) {
                assert (ord != -1L);
                return (long)this.values.get(ord);
            }
        }
    }

    static class Empty
    extends FloatArrayAtomicFieldData {
        Empty() {
        }

        @Override
        public LongValues getLongValues() {
            return LongValues.EMPTY;
        }

        @Override
        public DoubleValues getDoubleValues() {
            return DoubleValues.EMPTY;
        }

        public long ramBytesUsed() {
            return 0L;
        }

        @Override
        public BytesValues getBytesValues() {
            return BytesValues.EMPTY;
        }

        @Override
        public ScriptDocValues getScriptValues() {
            return ScriptDocValues.EMPTY_DOUBLES;
        }
    }
}

