/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.SizeBlockingQueue;
import org.elasticsearch.common.util.concurrent.XRejectedExecutionHandler;

public class EsAbortPolicy
implements XRejectedExecutionHandler {
    private final CounterMetric rejected = new CounterMetric();
    public static final String SHUTTING_DOWN_KEY = "(shutting down)";

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        if (r instanceof AbstractRunnable && ((AbstractRunnable)r).isForceExecution()) {
            BlockingQueue<Runnable> queue = executor.getQueue();
            if (!(queue instanceof SizeBlockingQueue)) {
                throw new ElasticsearchIllegalStateException("forced execution, but expected a size queue");
            }
            try {
                ((SizeBlockingQueue)queue).forcePut(r);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ElasticsearchIllegalStateException("forced execution, but got interrupted", e);
            }
            return;
        }
        this.rejected.inc();
        StringBuilder sb = new StringBuilder("rejected execution ");
        if (executor.isShutdown()) {
            sb.append("(shutting down) ");
        } else if (executor.getQueue() instanceof SizeBlockingQueue) {
            sb.append("(queue capacity ").append(((SizeBlockingQueue)executor.getQueue()).capacity()).append(") ");
        }
        sb.append("on ").append(r.toString());
        throw new EsRejectedExecutionException(sb.toString());
    }

    @Override
    public long rejected() {
        return this.rejected.count();
    }
}

