/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.indexedscripts.delete;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.uid.Versions;
import org.elasticsearch.index.VersionType;

public class DeleteIndexedScriptRequest
extends ActionRequest<DeleteIndexedScriptRequest> {
    private String scriptLang;
    private String id;
    @Nullable
    private long version = -3L;
    private VersionType versionType = VersionType.INTERNAL;

    public DeleteIndexedScriptRequest(String scriptLang, String id) {
        this.scriptLang = scriptLang;
        this.id = id;
    }

    public DeleteIndexedScriptRequest(DeleteIndexedScriptRequest request) {
        super(request);
        this.scriptLang = request.scriptLang();
        this.id = request.id();
        this.version = request.version();
        this.versionType = request.versionType();
    }

    public DeleteIndexedScriptRequest() {
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.scriptLang == null) {
            validationException = ValidateActions.addValidationError("scriptLang is missing", validationException);
        }
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        if (!this.versionType.validateVersionForWrites(this.version)) {
            validationException = ValidateActions.addValidationError("illegal version value [" + this.version + "] for version scriptLang [" + this.versionType.name() + "]", validationException);
        }
        return validationException;
    }

    public String scriptLang() {
        return this.scriptLang;
    }

    public DeleteIndexedScriptRequest scriptLang(String type) {
        this.scriptLang = type;
        return this;
    }

    public String id() {
        return this.id;
    }

    public DeleteIndexedScriptRequest id(String id) {
        this.id = id;
        return this;
    }

    public DeleteIndexedScriptRequest version(long version) {
        this.version = version;
        return this;
    }

    public long version() {
        return this.version;
    }

    public DeleteIndexedScriptRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.scriptLang = in.readString();
        this.id = in.readString();
        this.version = Versions.readVersion(in);
        this.versionType = VersionType.fromValue(in.readByte());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.scriptLang);
        out.writeString(this.id);
        Versions.writeVersion(this.version, out);
        out.writeByte(this.versionType.getValue());
    }

    public String toString() {
        return "delete {[.scripts][" + this.scriptLang + "][" + this.id + "]}";
    }
}

