/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.status;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.status.DocsStatus;
import org.elasticsearch.action.admin.indices.status.IndexShardStatus;
import org.elasticsearch.action.admin.indices.status.ShardStatus;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.refresh.RefreshStats;

@Deprecated
public class IndexStatus
implements Iterable<IndexShardStatus> {
    private final String index;
    private final Map<Integer, IndexShardStatus> indexShards;
    private transient DocsStatus docs;

    IndexStatus(String index, ShardStatus[] shards) {
        this.index = index;
        HashMap tmpIndexShards = Maps.newHashMap();
        for (ShardStatus shard : shards) {
            ArrayList<ShardStatus> lst = (ArrayList<ShardStatus>)tmpIndexShards.get(shard.getShardRouting().id());
            if (lst == null) {
                lst = Lists.newArrayList();
                tmpIndexShards.put(shard.getShardRouting().id(), lst);
            }
            lst.add(shard);
        }
        this.indexShards = Maps.newHashMap();
        for (Map.Entry entry : tmpIndexShards.entrySet()) {
            this.indexShards.put((Integer)entry.getKey(), new IndexShardStatus(((ShardStatus)((List)entry.getValue()).get(0)).getShardRouting().shardId(), ((List)entry.getValue()).toArray(new ShardStatus[((List)entry.getValue()).size()])));
        }
    }

    public String getIndex() {
        return this.index;
    }

    public Map<Integer, IndexShardStatus> getShards() {
        return this.indexShards;
    }

    public ByteSizeValue getPrimaryStoreSize() {
        long bytes = -1L;
        for (IndexShardStatus shard : this) {
            if (shard.getPrimaryStoreSize() == null) continue;
            if (bytes == -1L) {
                bytes = 0L;
            }
            bytes += shard.getPrimaryStoreSize().bytes();
        }
        if (bytes == -1L) {
            return null;
        }
        return new ByteSizeValue(bytes);
    }

    public ByteSizeValue getStoreSize() {
        long bytes = -1L;
        for (IndexShardStatus shard : this) {
            if (shard.getStoreSize() == null) continue;
            if (bytes == -1L) {
                bytes = 0L;
            }
            bytes += shard.getStoreSize().bytes();
        }
        if (bytes == -1L) {
            return null;
        }
        return new ByteSizeValue(bytes);
    }

    public long getTranslogOperations() {
        long translogOperations = -1L;
        for (IndexShardStatus shard : this) {
            if (shard.getTranslogOperations() == -1L) continue;
            if (translogOperations == -1L) {
                translogOperations = 0L;
            }
            translogOperations += shard.getTranslogOperations();
        }
        return translogOperations;
    }

    public DocsStatus getDocs() {
        if (this.docs != null) {
            return this.docs;
        }
        DocsStatus docs = null;
        for (IndexShardStatus shard : this) {
            if (shard.getDocs() == null) continue;
            if (docs == null) {
                docs = new DocsStatus();
            }
            docs.numDocs += shard.getDocs().getNumDocs();
            docs.maxDoc += shard.getDocs().getMaxDoc();
            docs.deletedDocs += shard.getDocs().getDeletedDocs();
        }
        this.docs = docs;
        return docs;
    }

    public MergeStats getMergeStats() {
        MergeStats mergeStats = new MergeStats();
        for (IndexShardStatus shard : this) {
            mergeStats.add(shard.getMergeStats());
        }
        return mergeStats;
    }

    public RefreshStats getRefreshStats() {
        RefreshStats refreshStats = new RefreshStats();
        for (IndexShardStatus shard : this) {
            refreshStats.add(shard.getRefreshStats());
        }
        return refreshStats;
    }

    public FlushStats getFlushStats() {
        FlushStats flushStats = new FlushStats();
        for (IndexShardStatus shard : this) {
            flushStats.add(shard.getFlushStats());
        }
        return flushStats;
    }

    @Override
    public Iterator<IndexShardStatus> iterator() {
        return this.indexShards.values().iterator();
    }
}

