/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.intblock;

import java.io.IOException;
import org.apache.lucene.codecs.sep.IntIndexOutput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexOutput;

public abstract class FixedIntBlockIndexOutput
extends IntIndexOutput {
    protected final IndexOutput out;
    private final int blockSize;
    protected final int[] buffer;
    private int upto;

    protected FixedIntBlockIndexOutput(IndexOutput out, int fixedBlockSize) throws IOException {
        this.blockSize = fixedBlockSize;
        this.out = out;
        out.writeVInt(this.blockSize);
        this.buffer = new int[this.blockSize];
    }

    protected abstract void flushBlock() throws IOException;

    @Override
    public IntIndexOutput.Index index() {
        return new Index();
    }

    @Override
    public void write(int v) throws IOException {
        this.buffer[this.upto++] = v;
        if (this.upto == this.blockSize) {
            this.flushBlock();
            this.upto = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.upto > 0) {
                this.flushBlock();
            }
        }
        finally {
            this.out.close();
        }
    }

    private class Index
    extends IntIndexOutput.Index {
        long fp;
        int upto;
        long lastFP;
        int lastUpto;

        private Index() {
        }

        @Override
        public void mark() throws IOException {
            this.fp = FixedIntBlockIndexOutput.this.out.getFilePointer();
            this.upto = FixedIntBlockIndexOutput.this.upto;
        }

        @Override
        public void copyFrom(IntIndexOutput.Index other, boolean copyLast) throws IOException {
            Index idx = (Index)other;
            this.fp = idx.fp;
            this.upto = idx.upto;
            if (copyLast) {
                this.lastFP = this.fp;
                this.lastUpto = this.upto;
            }
        }

        @Override
        public void write(DataOutput indexOut, boolean absolute) throws IOException {
            if (absolute) {
                indexOut.writeVInt(this.upto);
                indexOut.writeVLong(this.fp);
            } else if (this.fp == this.lastFP) {
                assert (this.upto >= this.lastUpto);
                int uptoDelta = this.upto - this.lastUpto;
                indexOut.writeVInt(uptoDelta << 1 | 1);
            } else {
                indexOut.writeVInt(this.upto << 1);
                indexOut.writeVLong(this.fp - this.lastFP);
            }
            this.lastUpto = this.upto;
            this.lastFP = this.fp;
        }

        public String toString() {
            return "fp=" + this.fp + " upto=" + this.upto;
        }
    }
}

