/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.search.facet.Facet;

public abstract class InternalFacet
implements Facet,
Streamable,
ToXContent {
    private String facetName;

    protected InternalFacet() {
    }

    protected InternalFacet(String facetName) {
        this.facetName = facetName;
    }

    public abstract BytesReference streamType();

    public abstract Facet reduce(ReduceContext var1);

    @Override
    public final String getName() {
        return this.facetName;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.facetName = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.facetName);
    }

    public static class Streams {
        private static ImmutableMap<BytesReference, Stream> streams = ImmutableMap.of();

        public static synchronized void registerStream(Stream stream, BytesReference ... types) {
            MapBuilder<BytesReference, Stream> uStreams = MapBuilder.newMapBuilder(streams);
            for (BytesReference type : types) {
                uStreams.put(type, stream);
            }
            streams = uStreams.immutableMap();
        }

        public static Stream stream(BytesReference type) {
            return streams.get(type);
        }
    }

    public static interface Stream {
        public Facet readFacet(StreamInput var1) throws IOException;
    }

    public static class ReduceContext {
        private final CacheRecycler cacheRecycler;
        private final List<Facet> facets;

        public ReduceContext(CacheRecycler cacheRecycler, List<Facet> facets) {
            this.cacheRecycler = cacheRecycler;
            this.facets = facets;
        }

        public CacheRecycler cacheRecycler() {
            return this.cacheRecycler;
        }

        public List<Facet> facets() {
            return this.facets;
        }
    }
}

