/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzerWrapper;
import org.elasticsearch.index.analysis.AnalyzerScope;

public class NamedAnalyzer
extends SimpleAnalyzerWrapper {
    private final String name;
    private final AnalyzerScope scope;
    private final Analyzer analyzer;
    private final int positionOffsetGap;

    public NamedAnalyzer(NamedAnalyzer analyzer, int positionOffsetGap) {
        this(analyzer.name(), analyzer.scope(), analyzer.analyzer(), positionOffsetGap);
    }

    public NamedAnalyzer(String name, Analyzer analyzer) {
        this(name, AnalyzerScope.INDEX, analyzer);
    }

    public NamedAnalyzer(String name, AnalyzerScope scope, Analyzer analyzer) {
        this(name, scope, analyzer, Integer.MIN_VALUE);
    }

    public NamedAnalyzer(String name, AnalyzerScope scope, Analyzer analyzer, int positionOffsetGap) {
        this.name = name;
        this.scope = scope;
        this.analyzer = analyzer;
        this.positionOffsetGap = positionOffsetGap;
    }

    public String name() {
        return this.name;
    }

    public AnalyzerScope scope() {
        return this.scope;
    }

    public Analyzer analyzer() {
        return this.analyzer;
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        return this.analyzer;
    }

    public int getPositionIncrementGap(String fieldName) {
        if (this.positionOffsetGap != Integer.MIN_VALUE) {
            return this.positionOffsetGap;
        }
        return super.getPositionIncrementGap(fieldName);
    }

    public String toString() {
        return "analyzer name[" + this.name + "], analyzer [" + this.analyzer + "]";
    }
}

