/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.rounding;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.rounding.TimeZoneRounding;

public abstract class Rounding
implements Streamable {
    public abstract byte id();

    public abstract long roundKey(long var1);

    public abstract long valueForKey(long var1);

    public final long round(long value) {
        return this.valueForKey(this.roundKey(value));
    }

    public abstract long nextRoundingValue(long var1);

    public static class Streams {
        public static void write(Rounding rounding, StreamOutput out) throws IOException {
            out.writeByte(rounding.id());
            rounding.writeTo(out);
        }

        public static Rounding read(StreamInput in) throws IOException {
            Rounding rounding = null;
            byte id = in.readByte();
            switch (id) {
                case 0: {
                    rounding = new Interval();
                    break;
                }
                case 1: {
                    rounding = new TimeZoneRounding.TimeTimeZoneRoundingFloor();
                    break;
                }
                case 2: {
                    rounding = new TimeZoneRounding.UTCTimeZoneRoundingFloor();
                    break;
                }
                case 3: {
                    rounding = new TimeZoneRounding.DayTimeZoneRoundingFloor();
                    break;
                }
                case 4: {
                    rounding = new TimeZoneRounding.UTCIntervalTimeZoneRounding();
                    break;
                }
                case 5: {
                    rounding = new TimeZoneRounding.TimeIntervalTimeZoneRounding();
                    break;
                }
                case 6: {
                    rounding = new TimeZoneRounding.DayIntervalTimeZoneRounding();
                    break;
                }
                case 7: {
                    rounding = new TimeZoneRounding.FactorTimeZoneRounding();
                    break;
                }
                case 8: {
                    rounding = new TimeZoneRounding.PrePostTimeZoneRounding();
                    break;
                }
                default: {
                    throw new ElasticsearchException("unknown rounding id [" + id + "]");
                }
            }
            rounding.readFrom(in);
            return rounding;
        }
    }

    public static class Interval
    extends Rounding {
        static final byte ID = 0;
        private long interval;

        public Interval() {
        }

        public Interval(long interval) {
            this.interval = interval;
        }

        @Override
        public byte id() {
            return 0;
        }

        public static long roundKey(long value, long interval) {
            if (value < 0L) {
                return (value - interval + 1L) / interval;
            }
            return value / interval;
        }

        public static long roundValue(long key, long interval) {
            return key * interval;
        }

        @Override
        public long roundKey(long value) {
            return Interval.roundKey(value, this.interval);
        }

        @Override
        public long valueForKey(long key) {
            return key * this.interval;
        }

        @Override
        public long nextRoundingValue(long value) {
            assert (value == this.round(value));
            return value + this.interval;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.interval = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.interval);
        }
    }
}

