/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.updates;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import util.FileUtil;

public class UpdateFileList {
    private static final Logger LOG = Logger.getLogger(UpdateFileList.class.getName());
    private List<String> mainDirectories;
    private String updateListContent = "";
    private String updateDoNotCopyOverContent = "";
    private HashSet<String> doNotReplaceFiles = new HashSet();
    private String baseDirectory = "";
    private String outputDirectory = "";
    static UpdateFileList testUpdater = null;

    public static void main(String[] args) {
        UpdateFileList updater = testUpdater != null ? testUpdater : new UpdateFileList();
        updater.parseCommandLine(args);
        if (updater.directoriesAreValid()) {
            updater.createUpdateList();
            updater.createDoNotUpdateList();
        } else {
            LOG.severe("Some directories are invalid. Aborting.");
            updater.exit();
        }
    }

    void exit() {
        System.exit(1);
    }

    public UpdateFileList() {
        this.mainDirectories = new ArrayList<String>();
    }

    public boolean parseCommandLine(String[] args) {
        if (args.length == 0) {
            return false;
        }
        for (String arg : args) {
            this.parseArgument(arg);
        }
        return true;
    }

    private void parseArgument(String arg) {
        if (arg.startsWith("-doNotReplace:")) {
            this.addADoNotReplaceFileName(arg);
        } else if (arg.startsWith("-baseDirectory:")) {
            this.baseDirectory = this.parseDirectoryArgument(arg);
        } else if (arg.startsWith("-outputDirectory:")) {
            this.outputDirectory = this.parseDirectoryArgument(arg);
        } else {
            this.mainDirectories.add(this.baseDirectory + arg);
        }
    }

    private void addADoNotReplaceFileName(String arg) {
        String[] components = arg.split(":");
        this.doNotReplaceFiles.add(components[1]);
    }

    private String parseDirectoryArgument(String arg) {
        String dir = arg.substring(arg.indexOf(58) + 1);
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        return dir;
    }

    public List<String> getDirectories() {
        return this.mainDirectories;
    }

    public boolean directoriesAreValid() {
        for (String dirName : this.mainDirectories) {
            File checkFile = new File(dirName);
            if (checkFile.exists()) continue;
            return false;
        }
        return true;
    }

    public File createUpdateList() {
        for (String dirName : this.mainDirectories) {
            this.addFilePathsToList(dirName);
        }
        return FileUtil.createFile(new File(this.outputDirectory + "updateList"), this.updateListContent);
    }

    private void addFilePathsToList(String directoryPath) {
        File[] files;
        File directory = new File(directoryPath);
        for (File childFile : files = FileUtil.getDirectoryListing(directory)) {
            if (this.isBackupFile(childFile)) continue;
            this.addFilePathToAppropriateList(directoryPath, childFile);
        }
    }

    private boolean isBackupFile(File childFile) {
        return childFile.getName().endsWith(".zip");
    }

    private void addFilePathToAppropriateList(String directoryPath, File childFile) {
        String childPath = directoryPath + "/" + childFile.getName();
        if (childFile.isDirectory()) {
            this.addFilePathsToList(childPath);
        } else if (this.isDoNotReplaceFile(childFile)) {
            this.updateDoNotCopyOverContent = this.updateDoNotCopyOverContent + this.makePathLine(childPath);
        } else {
            this.updateListContent = this.updateListContent + this.makePathLine(childPath);
        }
    }

    private String makePathLine(String path) {
        if (this.baseDirectory != null && this.baseDirectory.length() > 0 && path.startsWith(this.baseDirectory)) {
            path = path.replace(this.baseDirectory, "");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path + "\n";
    }

    private boolean isDoNotReplaceFile(File file) {
        String name = file.getPath();
        String baseDirectoryOnOS = this.baseDirectory.replace("/", File.separator);
        name = name.replace(baseDirectoryOnOS, "");
        name = name.replace(File.separator, "/");
        return this.doNotReplaceFiles.contains(name);
    }

    public File createDoNotUpdateList() {
        if (this.updateDoNotCopyOverContent.equals("")) {
            for (String dirName : this.mainDirectories) {
                this.addFilePathsToList(dirName);
            }
        }
        return FileUtil.createFile(new File(this.outputDirectory + "updateDoNotCopyOverList"), this.updateDoNotCopyOverContent);
    }
}

