/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.slim;

import fitnesse.slim.ListExecutor;
import fitnesse.slim.SlimFactory;
import fitnesse.slim.protocol.SlimDeserializer;
import fitnesse.slim.protocol.SlimSerializer;
import fitnesse.socketservice.SocketServer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.List;
import util.StreamReader;

public class SlimServer
implements SocketServer {
    public static final String MALFORMED_INSTRUCTION = "MALFORMED_INSTRUCTION";
    public static final String NO_CLASS = "NO_CLASS";
    public static final String NO_INSTANCE = "NO_INSTANCE";
    public static final String NO_CONVERTER_FOR_ARGUMENT_NUMBER = "NO_CONVERTER_FOR_ARGUMENT_NUMBER";
    public static final String NO_CONSTRUCTOR = "NO_CONSTRUCTOR";
    public static final String NO_METHOD_IN_CLASS = "NO_METHOD_IN_CLASS";
    public static final String COULD_NOT_INVOKE_CONSTRUCTOR = "COULD_NOT_INVOKE_CONSTRUCTOR";
    public static final String EXCEPTION_TAG = "__EXCEPTION__:";
    public static final String EXCEPTION_STOP_TEST_TAG = "__EXCEPTION__:ABORT_SLIM_TEST:";
    private StreamReader reader;
    private BufferedWriter writer;
    private ListExecutor executor;
    private boolean verbose;
    private SlimFactory slimFactory;

    public SlimServer(boolean verbose, SlimFactory slimFactory) {
        this.verbose = verbose;
        this.slimFactory = slimFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serve(Socket s) {
        try {
            this.tryProcessInstructions(s);
        }
        catch (Throwable e) {
            System.err.println("Error while executing SLIM instructions: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        finally {
            this.slimFactory.stop();
            this.close();
        }
    }

    private void tryProcessInstructions(Socket s) throws IOException {
        this.initialize(s);
        boolean more = true;
        while (more) {
            more = this.processOneSetOfInstructions();
        }
    }

    private void initialize(Socket s) throws IOException {
        this.executor = this.slimFactory.getListExecutor(this.verbose);
        this.reader = new StreamReader(s.getInputStream());
        this.writer = new BufferedWriter(new OutputStreamWriter(s.getOutputStream(), "UTF-8"));
        this.writer.write(String.format("Slim -- V%s\n", "0.3"));
        this.writer.flush();
    }

    private boolean processOneSetOfInstructions() throws IOException {
        String instructions = this.getInstructionsFromClient();
        if (instructions != null) {
            return this.processTheInstructions(instructions);
        }
        return true;
    }

    private String getInstructionsFromClient() throws IOException {
        int instructionLength = this.getLengthToRead();
        String instructions = this.reader.read(instructionLength);
        return instructions;
    }

    private int getLengthToRead() throws IOException {
        String lengthField = this.reader.readUpTo(":");
        try {
            return Integer.parseInt(lengthField);
        }
        catch (NumberFormatException e) {
            throw new IOException("Stream Read Failure. Can't read length of message from the client.  Last thing read: " + lengthField);
        }
    }

    private boolean processTheInstructions(String instructions) throws IOException {
        if (instructions.equalsIgnoreCase("bye")) {
            return false;
        }
        List<Object> results = this.executeInstructions(instructions);
        this.sendResultsToClient(results);
        return true;
    }

    private List<Object> executeInstructions(String instructions) {
        List<Object> statements = SlimDeserializer.deserialize(instructions);
        List<Object> results = this.executor.execute(statements);
        return results;
    }

    private void sendResultsToClient(List<Object> results) throws IOException {
        String resultString = SlimSerializer.serialize(results);
        this.writer.write(String.format("%06d:%s", resultString.getBytes("UTF-8").length, resultString));
        this.writer.flush();
    }

    private void close() {
        try {
            this.reader.close();
            this.writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

