/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.FitNesseContext;
import fitnesse.authentication.AlwaysSecureOperation;
import fitnesse.http.MockRequest;
import fitnesse.http.RequestBuilder;
import fitnesse.http.ResponseParser;
import fitnesse.responders.ShutdownResponder;
import fitnesse.testutil.FitNesseUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ShutdownResponderTest {
    private FitNesseContext context;
    private boolean doneShuttingDown;

    @Before
    public void setUp() throws Exception {
        this.context = FitNesseUtil.makeTestContext(1999);
        this.context.fitNesse.start();
    }

    @After
    public void tearDown() throws Exception {
        this.context.fitNesse.stop();
    }

    @Test
    public void testFitNesseGetsShutdown() throws Exception {
        ShutdownResponder responder = new ShutdownResponder();
        responder.makeResponse(this.context, new MockRequest());
        Thread.sleep(200L);
        Assert.assertFalse((boolean)this.context.fitNesse.isRunning());
    }

    @Test
    public void testShutdownCalledFromServer() throws Exception {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    RequestBuilder request = new RequestBuilder("/?responder=shutdown");
                    ResponseParser.performHttpRequest("localhost", 1999, request);
                    ShutdownResponderTest.this.doneShuttingDown = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        thread.start();
        Thread.sleep(500L);
        Assert.assertTrue((boolean)this.doneShuttingDown);
        Assert.assertFalse((boolean)this.context.fitNesse.isRunning());
    }

    @Test
    public void testIsSecure() throws Exception {
        Assert.assertTrue((boolean)(new ShutdownResponder().getSecureOperation() instanceof AlwaysSecureOperation));
    }
}

