/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.responders;

import fitnesse.authentication.SecureOperation;
import fitnesse.authentication.SecureReadOperation;
import fitnesse.responders.BasicWikiPageResponder;
import fitnesse.wiki.WikiPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONArray;
import util.StringUtil;

public class NameWikiPageResponder
extends BasicWikiPageResponder {
    @Override
    protected String contentFrom(WikiPage requestedPage) {
        List<String> lines = this.addLines(requestedPage, "");
        String format = (String)this.request.getInput("format");
        if ("json".equalsIgnoreCase(format)) {
            JSONArray jsonPages = new JSONArray(lines);
            return jsonPages.toString();
        }
        return StringUtil.join(lines, System.getProperty("line.separator"));
    }

    private List<String> addLines(WikiPage requestedPage, String prefix) {
        ArrayList<String> lines = new ArrayList<String>();
        for (WikiPage child : requestedPage.getChildren()) {
            if (!this.request.hasInput("LeafOnly") || child.getChildren().isEmpty()) {
                lines.add(this.makeLine(child, prefix));
            }
            if (!this.request.hasInput("Recursive")) continue;
            lines.addAll(this.addLines(child, prefix + child.getName() + "."));
        }
        return lines;
    }

    private String makeLine(WikiPage child, String prefix) {
        Set<String> tags;
        int numberOfChildren = child.getChildren().size();
        StringBuilder line = new StringBuilder(64).append(prefix).append(child.getName());
        if (this.request.hasInput("ShowChildCount")) {
            line.append(" ").append(numberOfChildren);
        }
        if (this.request.hasInput("ShowTags") && !(tags = this.getTags(child)).isEmpty()) {
            line.append(" ");
            for (String tag : tags) {
                line.append("[").append(tag).append("]");
            }
        }
        return line.toString();
    }

    private Set<String> getTags(WikiPage page) {
        TreeSet<String> result = new TreeSet<String>();
        String tags = page.getData().getAttribute("Suites");
        if (tags != null && !tags.isEmpty()) {
            result.addAll(Arrays.asList(tags.split(", ")));
        }
        if (!page.isRoot()) {
            result.addAll(this.getTags(page.getParent()));
        }
        return result;
    }

    @Override
    protected String getContentType() {
        return "text/plain";
    }

    @Override
    public SecureOperation getSecureOperation() {
        return new SecureReadOperation();
    }
}

