/*
 * Decompiled with CFR 0.152.
 */
package fit;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import util.GracefulNamer;

public class FixtureName {
    private final String nameAsString;

    public FixtureName(String tableName) {
        this.nameAsString = GracefulNamer.isGracefulName(tableName) ? GracefulNamer.disgrace(tableName) : tableName;
    }

    public String toString() {
        return this.nameAsString;
    }

    public boolean isFullyQualified() {
        return this.nameAsString.indexOf(46) != -1;
    }

    public static boolean fixtureNameHasPackageSpecified(String fixtureName) {
        return new FixtureName(fixtureName).isFullyQualified();
    }

    public List<String> getPotentialFixtureClassNames(Set<String> fixturePathElements) {
        ArrayList<String> candidateClassNames = new ArrayList<String>();
        if (!this.isFullyQualified()) {
            for (String packageName : fixturePathElements) {
                this.addBlahAndBlahFixture(packageName + ".", candidateClassNames);
            }
        }
        this.addBlahAndBlahFixture("", candidateClassNames);
        return candidateClassNames;
    }

    private void addBlahAndBlahFixture(String qualifiedBy, List<String> candidateClassNames) {
        candidateClassNames.add(qualifiedBy + this.nameAsString);
        candidateClassNames.add(qualifiedBy + this.nameAsString + "Fixture");
    }
}

