/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.NoSuchDirectoryException;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.IOUtils;

public abstract class FSDirectory
extends BaseDirectory {
    @Deprecated
    public static final int DEFAULT_READ_CHUNK_SIZE = 8192;
    protected final File directory;
    protected final Set<String> staleFiles = Collections.synchronizedSet(new HashSet());
    private int chunkSize = 8192;

    private static File getCanonicalPath(File file) throws IOException {
        return new File(file.getCanonicalPath());
    }

    protected FSDirectory(File path, LockFactory lockFactory) throws IOException {
        if (lockFactory == null) {
            lockFactory = new NativeFSLockFactory();
        }
        this.directory = FSDirectory.getCanonicalPath(path);
        if (this.directory.exists() && !this.directory.isDirectory()) {
            throw new NoSuchDirectoryException("file '" + this.directory + "' exists but is not a directory");
        }
        this.setLockFactory(lockFactory);
    }

    public static FSDirectory open(File path) throws IOException {
        return FSDirectory.open(path, null);
    }

    public static FSDirectory open(File path, LockFactory lockFactory) throws IOException {
        if (Constants.JRE_IS_64BIT && MMapDirectory.UNMAP_SUPPORTED) {
            return new MMapDirectory(path, lockFactory);
        }
        if (Constants.WINDOWS) {
            return new SimpleFSDirectory(path, lockFactory);
        }
        return new NIOFSDirectory(path, lockFactory);
    }

    @Override
    public void setLockFactory(LockFactory lockFactory) throws IOException {
        super.setLockFactory(lockFactory);
        if (lockFactory instanceof FSLockFactory) {
            FSLockFactory lf = (FSLockFactory)lockFactory;
            File dir = lf.getLockDir();
            if (dir == null) {
                lf.setLockDir(this.directory);
                lf.setLockPrefix(null);
            } else if (dir.getCanonicalPath().equals(this.directory.getCanonicalPath())) {
                lf.setLockPrefix(null);
            }
        }
    }

    public static String[] listAll(File dir) throws IOException {
        if (!dir.exists()) {
            throw new NoSuchDirectoryException("directory '" + dir + "' does not exist");
        }
        if (!dir.isDirectory()) {
            throw new NoSuchDirectoryException("file '" + dir + "' exists but is not a directory");
        }
        String[] result = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String file) {
                return !new File(dir, file).isDirectory();
            }
        });
        if (result == null) {
            throw new IOException("directory '" + dir + "' exists and is a directory, but cannot be listed: list() returned null");
        }
        return result;
    }

    @Override
    public String[] listAll() throws IOException {
        this.ensureOpen();
        return FSDirectory.listAll(this.directory);
    }

    @Override
    public boolean fileExists(String name) {
        this.ensureOpen();
        File file = new File(this.directory, name);
        return file.exists();
    }

    @Override
    public long fileLength(String name) throws IOException {
        this.ensureOpen();
        File file = new File(this.directory, name);
        long len = file.length();
        if (len == 0L && !file.exists()) {
            throw new FileNotFoundException(name);
        }
        return len;
    }

    @Override
    public void deleteFile(String name) throws IOException {
        this.ensureOpen();
        File file = new File(this.directory, name);
        if (!file.delete()) {
            throw new IOException("Cannot delete " + file);
        }
        this.staleFiles.remove(name);
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        this.ensureCanWrite(name);
        return new FSIndexOutput(name);
    }

    protected void ensureCanWrite(String name) throws IOException {
        if (!this.directory.exists() && !this.directory.mkdirs()) {
            throw new IOException("Cannot create directory: " + this.directory);
        }
        File file = new File(this.directory, name);
        if (file.exists() && !file.delete()) {
            throw new IOException("Cannot overwrite: " + file);
        }
    }

    protected void onIndexOutputClosed(String name) {
        this.staleFiles.add(name);
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
        this.ensureOpen();
        HashSet<String> toSync = new HashSet<String>(names);
        toSync.retainAll(this.staleFiles);
        for (String name : toSync) {
            this.fsync(name);
        }
        if (!toSync.isEmpty()) {
            IOUtils.fsync(this.directory, true);
        }
        this.staleFiles.removeAll(toSync);
    }

    @Override
    public String getLockID() {
        String dirName;
        this.ensureOpen();
        try {
            dirName = this.directory.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString(), e);
        }
        int digest = 0;
        for (int charIDX = 0; charIDX < dirName.length(); ++charIDX) {
            char ch = dirName.charAt(charIDX);
            digest = 31 * digest + ch;
        }
        return "lucene-" + Integer.toHexString(digest);
    }

    @Override
    public synchronized void close() {
        this.isOpen = false;
    }

    public File getDirectory() {
        this.ensureOpen();
        return this.directory;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "@" + this.directory + " lockFactory=" + this.getLockFactory();
    }

    @Deprecated
    public final void setReadChunkSize(int chunkSize) {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize must be positive");
        }
        this.chunkSize = chunkSize;
    }

    @Deprecated
    public final int getReadChunkSize() {
        return this.chunkSize;
    }

    protected void fsync(String name) throws IOException {
        IOUtils.fsync(new File(this.directory, name), false);
    }

    final class FSIndexOutput
    extends OutputStreamIndexOutput {
        static final int CHUNK_SIZE = 8192;
        private final String name;

        public FSIndexOutput(String name) throws IOException {
            super(new FilterOutputStream(new FileOutputStream(new File(FSDirectory.this.directory, name))){

                @Override
                public void write(byte[] b, int offset, int length) throws IOException {
                    while (length > 0) {
                        int chunk = Math.min(length, 8192);
                        this.out.write(b, offset, chunk);
                        length -= chunk;
                        offset += chunk;
                    }
                }
            }, 8192);
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                FSDirectory.this.onIndexOutputClosed(this.name);
            }
            finally {
                super.close();
            }
        }
    }
}

