/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.resources;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xltest.domain.Event;
import com.xebialabs.xltest.domain.EventHandler;
import com.xebialabs.xltest.domain.Qualification;
import com.xebialabs.xltest.domain.Qualifier;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.domain.TestSpecification;
import com.xebialabs.xltest.domain.TestTool;
import com.xebialabs.xltest.repository.NoTestRunFoundException;
import com.xebialabs.xltest.repository.TestRunsRepository;
import com.xebialabs.xltest.repository.TestSpecificationRepository;
import com.xebialabs.xltest.repository.TestTools;
import com.xebialabs.xltest.service.EventRepository;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/import")
public class ImportController {
    private static final Logger LOG = LoggerFactory.getLogger(ImportController.class);
    public static final String REMOTE_TRACKING_ID = "XL_TEST_RUN_ID";
    private final TestTools testTools;
    private final RepositoryService repository;
    private final TestSpecificationRepository testSpecifications;
    private final EventRepository eventRepository;
    private final TestRunsRepository testRunsRepository;

    @Autowired
    public ImportController(TestTools testTools, RepositoryService repository, EventRepository eventRepository, TestRunsRepository testRunsRepository, TestSpecificationRepository testSpecificationRepository) {
        this.testTools = testTools;
        this.repository = repository;
        this.eventRepository = eventRepository;
        this.testRunsRepository = testRunsRepository;
        this.testSpecifications = testSpecificationRepository;
    }

    @POST
    @Path(value="/{jobName:.+}")
    public Response importTestResultsSentByJenkins(@PathParam(value="jobName") String jobName, @Context HttpServletRequest request) throws Exception {
        TestSpecification testSpecification = null;
        UUID testRunId = this.getTestRunId(request);
        if (testRunId != null) {
            try {
                TestRun testRun = this.testRunsRepository.getTestRun(testRunId);
                testSpecification = this.testSpecifications.get(testRun.getTestSpecificationName());
            }
            catch (NoTestRunFoundException e) {
                LOG.warn("A test run id ({}) was provided, but no run has been found in the database.");
            }
        } else {
            testRunId = UUID.randomUUID();
        }
        if (testSpecification == null) {
            testSpecification = this.testSpecifications.findOrCreateTestSpecificationWithJenkinsHost(jobName, request.getParameter("tool"), request.getParameter("pattern"), request.getParameter("jenkinsUrl"));
        }
        File localWorkspaceDirectory = this.extractZipInputStreamToTempLocalWorkspaceDirectory(request);
        final HashMap<String, Object> extraEventProperties = new HashMap<String, Object>(this.toSimpleMap(request.getParameterMap()));
        extraEventProperties.put("jobName", jobName);
        extraEventProperties.put("testSpecification", testSpecification.getName());
        TestTool testTool = this.testTools.findByName(testSpecification.getTestToolName());
        this.setDefaultQualificationIfAbsent(testSpecification, testTool.getCategory());
        final Qualifier qualifier = testSpecification.getQualification().getQualifier(testRunId, this.testRunsRepository);
        testSpecification.doImport(testRunId, testTool, LocalFile.valueOf((File)localWorkspaceDirectory), new EventHandler(){

            @Override
            public void onReceive(Event event) throws Exception {
                Event eventWithSlaveInfo = new Event(event, (Map)extraEventProperties);
                qualifier.update(eventWithSlaveInfo);
                ImportController.this.eventRepository.insert(eventWithSlaveInfo);
            }
        });
        this.eventRepository.insert(new Event(qualifier.getEvent(), extraEventProperties));
        return Response.ok().build();
    }

    private Map<String, Object> toSimpleMap(Map<String, String[]> parameterMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(parameterMap.size());
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            resultMap.put(entry.getKey(), entry.getValue()[0]);
        }
        return resultMap;
    }

    private UUID getTestRunId(HttpServletRequest request) {
        String parameterValue = request.getParameter(REMOTE_TRACKING_ID);
        if (!Strings.isNullOrEmpty((String)parameterValue)) {
            String result = (String)Splitter.on((char)'/').omitEmptyStrings().splitToList((CharSequence)parameterValue).get(0);
            return UUID.fromString(result);
        }
        return null;
    }

    private File extractZipInputStreamToTempLocalWorkspaceDirectory(HttpServletRequest request) throws IOException {
        ServletInputStream inputStream = request.getInputStream();
        File localWorkspaceDirectory = Files.createTempDir();
        this.extractZipInputStream(localWorkspaceDirectory, (InputStream)inputStream);
        inputStream.close();
        LOG.info("Extracted zip content into: " + localWorkspaceDirectory.getAbsolutePath());
        return localWorkspaceDirectory;
    }

    private void extractZipInputStream(File baseDir, InputStream is) throws IOException {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(is);
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            File file = new File(baseDir, entry.getName());
            LOG.debug("Copying {} into file {}", (Object)entry.getName(), (Object)file);
            Files.createParentDirs((File)file);
            Files.write((byte[])ByteStreams.toByteArray((InputStream)zis), (File)file);
        }
    }

    private void setDefaultQualificationIfAbsent(TestSpecification testSpecification, String testToolCategory) {
        if (testSpecification.getQualification() == null) {
            String defaultQualificationId = null;
            if (testToolCategory.equals("functional")) {
                defaultQualificationId = "Configuration/Reports/default-functional-tests-qualifier";
            } else if (testToolCategory.equals("performance")) {
                defaultQualificationId = "Configuration/Reports/default-performance-tests-qualifier";
            }
            try {
                Qualification defaultQualification = (Qualification)this.repository.read(defaultQualificationId);
                testSpecification.setQualification(defaultQualification);
                this.repository.update((ConfigurationItem[])new TestSpecification[]{testSpecification});
                LOG.debug("testSpecification {} updated with default qualification {}", (Object)testSpecification.getId(), (Object)defaultQualificationId);
            }
            catch (Exception exception) {
                LOG.warn("Couldn't set default qualification {} on testSpecification {}", (Object)defaultQualificationId, (Object)testSpecification.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{testSpecificationId:.+}")
    @Produces(value={"text/event-stream"})
    public void getTestRun(@PathParam(value="testSpecificationId") String testSpecificationId, @Context HttpServletResponse response) throws Exception {
        TestSpecification testSpecification;
        response.setContentType("text/event-stream");
        response.setCharacterEncoding("UTF-8");
        response.addHeader("Cache-Control", "no-cache");
        response.addHeader("Connection", "keep-alive");
        final PrintWriter writer = response.getWriter();
        try {
            testSpecification = (TestSpecification)this.repository.read("Configuration/TestSpecifications/" + testSpecificationId);
        }
        catch (NotFoundException e) {
            this.closeEventStream(writer, e.getMessage());
            return;
        }
        try {
            TestTool testTool = this.testTools.findByName(testSpecification.getTestToolName());
            this.setDefaultQualificationIfAbsent(testSpecification, testTool.getCategory());
            final Qualifier[] qualifierHolder = new Qualifier[]{testSpecification.getQualification().getQualifier(UUID.randomUUID(), this.testRunsRepository)};
            testSpecification.doImport(testTool, testSpecification.getRemotePath(), new EventHandler(){

                @Override
                public void onReceive(Event event) throws Exception {
                    qualifierHolder[0].update(event);
                    ImportController.this.eventRepository.insert(event);
                }
            }, new TestSpecification.ProgressCallback(){

                @Override
                public void update(UUID testRunId, int percentage) {
                    ImportController.this.sendEvent(writer, percentage);
                    if (testRunId != null) {
                        ImportController.this.eventRepository.insert(new Event(testRunId, qualifierHolder[0].getEvent(), Collections.emptyMap()));
                    }
                    qualifierHolder[0] = testSpecification.getQualification().getQualifier(UUID.randomUUID(), ImportController.this.testRunsRepository);
                }
            });
        }
        finally {
            this.closeEventStream(writer);
        }
    }

    private void sendEvent(PrintWriter writer, int pct) {
        if (writer != null) {
            writer.write("event: event\n");
            writer.write("data: {\"percentage\":" + pct + "}\n\n");
            writer.flush();
        }
    }

    private void closeEventStream(PrintWriter writer) {
        if (writer != null) {
            writer.write("event: close\n");
            writer.write("data: {}\n\n");
            writer.close();
        }
    }

    private void closeEventStream(PrintWriter writer, String errorMessage) {
        if (writer != null) {
            writer.write("event: close\n");
            writer.write("data: {\"error\":\"" + errorMessage + "\"}\n\n");
            writer.close();
        }
    }
}

