/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.MultipleParentsNotAllowedException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.UnmergedPathsException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdRef;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeMessageFormatter;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.merge.ResolveMerger;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.FileTreeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevertCommand
extends GitCommand<RevCommit> {
    private List<Ref> commits = new LinkedList<Ref>();
    private String ourCommitName = null;
    private List<Ref> revertedRefs = new LinkedList<Ref>();
    private MergeResult failingResult;
    private List<String> unmergedPaths;

    protected RevertCommand(Repository repo) {
        super(repo);
    }

    @Override
    public RevCommit call() throws NoMessageException, UnmergedPathsException, ConcurrentRefUpdateException, WrongRepositoryStateException, GitAPIException {
        RevCommit newHead = null;
        this.checkCallable();
        RevWalk revWalk = new RevWalk(this.repo);
        try {
            RevCommit headCommit;
            Ref headRef = this.repo.getRef("HEAD");
            if (headRef == null) {
                throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
            }
            newHead = headCommit = revWalk.parseCommit(headRef.getObjectId());
            for (Ref src : this.commits) {
                RevCommit srcCommit;
                ObjectId srcObjectId = src.getPeeledObjectId();
                if (srcObjectId == null) {
                    srcObjectId = src.getObjectId();
                }
                if ((srcCommit = revWalk.parseCommit(srcObjectId)).getParentCount() != 1) {
                    throw new MultipleParentsNotAllowedException(MessageFormat.format(JGitText.get().canOnlyRevertCommitsWithOneParent, srcCommit.name(), srcCommit.getParentCount()));
                }
                RevCommit srcParent = srcCommit.getParent(0);
                revWalk.parseHeaders(srcParent);
                String ourName = this.calculateOurName(headRef);
                String revertName = srcCommit.getId().abbreviate(7).name() + " " + srcCommit.getShortMessage();
                ResolveMerger merger = (ResolveMerger)MergeStrategy.RESOLVE.newMerger(this.repo);
                merger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
                merger.setBase(srcCommit.getTree());
                merger.setCommitNames(new String[]{"BASE", ourName, revertName});
                String shortMessage = "Revert \"" + srcCommit.getShortMessage() + "\"";
                String newMessage = shortMessage + "\n\n" + "This reverts commit " + srcCommit.getId().getName() + ".\n";
                if (merger.merge(headCommit, srcParent)) {
                    if (AnyObjectId.equals(headCommit.getTree().getId(), merger.getResultTreeId())) continue;
                } else {
                    this.unmergedPaths = merger.getUnmergedPaths();
                    Map<String, ResolveMerger.MergeFailureReason> failingPaths = merger.getFailingPaths();
                    this.failingResult = failingPaths != null ? new MergeResult(null, merger.getBaseCommit(0, 1), new ObjectId[]{headCommit.getId(), srcParent.getId()}, MergeResult.MergeStatus.FAILED, MergeStrategy.RESOLVE, merger.getMergeResults(), failingPaths, null) : new MergeResult(null, merger.getBaseCommit(0, 1), new ObjectId[]{headCommit.getId(), srcParent.getId()}, MergeResult.MergeStatus.CONFLICTING, MergeStrategy.RESOLVE, merger.getMergeResults(), failingPaths, null);
                    if (!merger.failed() && !this.unmergedPaths.isEmpty()) {
                        String message = new MergeMessageFormatter().formatWithConflicts(newMessage, merger.getUnmergedPaths());
                        this.repo.writeRevertHead(srcCommit.getId());
                        this.repo.writeMergeCommitMsg(message);
                    }
                    RevCommit revCommit = null;
                    return revCommit;
                }
                DirCacheCheckout dco = new DirCacheCheckout(this.repo, headCommit.getTree(), this.repo.lockDirCache(), merger.getResultTreeId());
                dco.setFailOnConflict(true);
                dco.checkout();
                newHead = new Git(this.getRepository()).commit().setMessage(newMessage).setReflogComment("revert: " + shortMessage).call();
                this.revertedRefs.add(src);
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfRevertCommand, e), e);
        }
        finally {
            revWalk.release();
        }
        return newHead;
    }

    public RevertCommand include(Ref commit) {
        this.checkCallable();
        this.commits.add(commit);
        return this;
    }

    public RevertCommand include(AnyObjectId commit) {
        return this.include(commit.getName(), commit);
    }

    public RevertCommand include(String name, AnyObjectId commit) {
        return this.include(new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name, commit.copy()));
    }

    public RevertCommand setOurCommitName(String ourCommitName) {
        this.ourCommitName = ourCommitName;
        return this;
    }

    private String calculateOurName(Ref headRef) {
        if (this.ourCommitName != null) {
            return this.ourCommitName;
        }
        String targetRefName = headRef.getTarget().getName();
        String headName = Repository.shortenRefName(targetRefName);
        return headName;
    }

    public List<Ref> getRevertedRefs() {
        return this.revertedRefs;
    }

    public MergeResult getFailingResult() {
        return this.failingResult;
    }

    public List<String> getUnmergedPaths() {
        return this.unmergedPaths;
    }
}

