/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.upgrade;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.booter.local.PluginVersions;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.jcr.JcrCallback;
import com.xebialabs.deployit.jcr.JcrTemplate;
import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;
import com.xebialabs.deployit.upgrade.RawRepositoryImpl;
import com.xebialabs.deployit.upgrade.UpgradeRejectedException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import nl.javadude.scannit.Scannit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class Upgrader {
    private final Set<String> components = Sets.newLinkedHashSet();
    private final ListMultimap<String, Upgrade> upgrades = ArrayListMultimap.create();
    private final boolean forceUpgrades;
    private ApplicationContext context;
    private JcrTemplate jcrTemplate;
    private boolean questionAsked = false;
    private static final Logger logger = LoggerFactory.getLogger(Upgrader.class);

    public Upgrader(ApplicationContext context, JcrTemplate jcrTemplate, boolean forceUpgrades) {
        this.context = context;
        this.jcrTemplate = jcrTemplate;
        this.forceUpgrades = forceUpgrades;
    }

    public void addComponent(String component) {
        this.components.add(component);
    }

    public void addUpgrade(Upgrade upgrade) {
        String component = upgrade.upgradeVersion().getComponent();
        this.addComponent(component);
        this.upgrades.put((Object)component, (Object)upgrade);
    }

    public void applyUpgrades() {
        for (String component : this.components) {
            this.upgradeComponent(component);
        }
    }

    public void autoUpgrade() {
        this.components.addAll(PluginVersions.getRegisteredPlugins());
        this.upgrades.putAll(this.findUpgrades());
        this.applyUpgrades();
    }

    void upgradeComponent(String component) {
        logger.debug("Checking component [{}] for upgrades", (Object)component);
        Version componentVersion = null;
        try {
            componentVersion = this.readVersionOfComponent(component);
        }
        catch (RuntimeException e) {
            logger.info("Component [{}] has an invalid version -- skipping upgrade", (Object)component);
            return;
        }
        logger.debug("Component [{}] has version [{}] in the repository", (Object)component, (Object)componentVersion);
        List<Upgrade> applicableUpgrades = this.filterUpgrades(Upgrader.ensureNotNull(this.upgrades.get((Object)component)), componentVersion);
        if (!applicableUpgrades.isEmpty()) {
            Collections.sort(applicableUpgrades);
            logger.info("Checked component [{}] which is at version [{}] -> Found upgrades to run: {}", new Object[]{component, componentVersion, applicableUpgrades});
            if (!this.questionAsked && !this.forceUpgrades) {
                System.out.println("*** WARNING ***");
                System.out.println("We detected that we need to upgrade your repository");
                System.out.println("Before continuing we suggest you backup your repository in case the upgrade fails.");
                System.out.println("Please ensure you have 'INFO' level logging configured.");
                System.out.print("Please enter 'yes' if you want to continue [no]: ");
                String response = this.read();
                if (!"yes".equalsIgnoreCase(response)) {
                    logger.error("Did not receive an affirmative response on running upgrades, shutting down.");
                    EventBusHolder.publish(new ShutdownEvent());
                    throw new UpgradeRejectedException("Did not receive an affirmative response on running upgrades, shutting down.");
                }
                this.questionAsked = true;
            }
            this.applyUpgrades(applicableUpgrades);
        } else if (componentVersion.equals((Object)Version.valueOf((String)component, (String)"0.0.0"))) {
            if (PluginVersions.getVersionFor((String)component) == null) {
                logger.debug("Unknown component: [{}]", (Object)component);
                return;
            }
            Version currentPluginVersion = Version.valueOf((String)component, (String)PluginVersions.getVersionFor((String)component));
            logger.info("Registering previous unregistered version: [{}]", (Object)currentPluginVersion);
            this.storeVersionOfComponent(currentPluginVersion);
        }
    }

    void storeVersionOfComponent(final Version version) {
        this.jcrTemplate.execute(new JcrCallback<Object>(){

            @Override
            public Object doInJcr(Session session) throws RepositoryException {
                Node node = Upgrader.getVersionsNode(session);
                node.setProperty(version.getComponent(), version.getVersion());
                session.save();
                return null;
            }
        });
    }

    Version readVersionOfComponent(final String component) {
        return this.jcrTemplate.execute(new JcrCallback<Version>(){

            @Override
            public Version doInJcr(Session session) throws RepositoryException {
                Node node = Upgrader.getVersionsNode(session);
                if (node.hasProperty(component)) {
                    Property versionProp = node.getProperty(component);
                    return Version.valueOf((String)component, (String)versionProp.getString());
                }
                return Version.valueOf((String)component, (String)"0.0.0");
            }
        });
    }

    private static Node getVersionsNode(Session session) throws RepositoryException {
        try {
            return session.getNode("/$configuration/versions");
        }
        catch (PathNotFoundException pnfe) {
            return session.getRootNode().addNode("$configuration/versions");
        }
    }

    private void applyUpgrades(List<Upgrade> applicableUpgrades) {
        final ImmutableListMultimap versionToUpgradeMap = Multimaps.index(applicableUpgrades, (Function)new Function<Upgrade, Version>(){

            public Version apply(Upgrade input) {
                return input.upgradeVersion();
            }
        });
        TreeSet versions = Sets.newTreeSet((Iterable)Lists.transform(applicableUpgrades, (Function)new Function<Upgrade, Version>(){

            public Version apply(Upgrade input) {
                return input.upgradeVersion();
            }
        }));
        for (final Version version : versions) {
            logger.info("Upgrading to version [{}]", (Object)version);
            this.jcrTemplate.execute(new JcrCallback<Object>(){

                @Override
                public Object doInJcr(Session session) throws RepositoryException {
                    for (Upgrade applicableUpgrade : versionToUpgradeMap.get((Object)version)) {
                        if (applicableUpgrade.doUpgrade((RawRepository)new RawRepositoryImpl(session))) continue;
                        throw new UpgradeException("Could not perform upgrade %s to upgrade to %s", new Object[]{applicableUpgrade.getClass(), applicableUpgrade.upgradeVersion()});
                    }
                    session.save();
                    return null;
                }
            });
            this.storeVersionOfComponent(version);
        }
    }

    private List<Upgrade> filterUpgrades(Collection<Upgrade> upgradeBeans, final Version repoVersion) {
        if (repoVersion.getVersion().equals("0.0.0")) {
            return Lists.newArrayList();
        }
        ArrayList applicableUpgrades = Lists.newArrayList((Iterable)Collections2.filter(upgradeBeans, (Predicate)new Predicate<Upgrade>(){

            public boolean apply(Upgrade input) {
                return input.shouldBeApplied(repoVersion);
            }
        }));
        Collections.sort(applicableUpgrades);
        return applicableUpgrades;
    }

    protected ListMultimap<String, Upgrade> findUpgrades() {
        Set upgradeClasses = Scannit.getInstance().getSubTypesOf(Upgrade.class);
        logger.debug("Found the following upgraders: [{}]", (Object)upgradeClasses);
        return Multimaps.index((Iterable)Collections2.transform((Collection)upgradeClasses, (Function)new Function<Class<? extends Upgrade>, Upgrade>(){

            public Upgrade apply(Class<? extends Upgrade> input) {
                return (Upgrade)Upgrader.this.context.getAutowireCapableBeanFactory().createBean(input);
            }
        }), (Function)new Function<Upgrade, String>(){

            public String apply(Upgrade input) {
                return input.upgradeVersion().getComponent();
            }
        });
    }

    protected String read() {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line = stdin.readLine();
            if (line != null) {
                return line.trim();
            }
            return line;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static <T> List<T> ensureNotNull(List<T> list) {
        return list == null ? Lists.newArrayList() : list;
    }
}

