/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.postingsformat;

import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.memory.MemoryPostingsFormat;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.codec.postingsformat.AbstractPostingsFormatProvider;

public class MemoryPostingsFormatProvider
extends AbstractPostingsFormatProvider {
    private final boolean packFst;
    private final float acceptableOverheadRatio;
    private final MemoryPostingsFormat postingsFormat;

    @Inject
    public MemoryPostingsFormatProvider(@Assisted String name, @Assisted Settings postingsFormatSettings) {
        super(name);
        this.packFst = postingsFormatSettings.getAsBoolean("pack_fst", (Boolean)false);
        this.acceptableOverheadRatio = postingsFormatSettings.getAsFloat("acceptable_overhead_ratio", Float.valueOf(0.25f)).floatValue();
        this.postingsFormat = new MemoryPostingsFormat(this.packFst, this.acceptableOverheadRatio);
    }

    public boolean packFst() {
        return this.packFst;
    }

    public float acceptableOverheadRatio() {
        return this.acceptableOverheadRatio;
    }

    @Override
    public PostingsFormat get() {
        return this.postingsFormat;
    }
}

