package com.xebialabs.xltest.view;

import java.util.Map;
import java.util.Set;
import com.google.common.base.Strings;

public class ExecutionParameterRequest {
    private final Map<String, Set<String>> parameters;
    private String hostId;
    private String commandLine;

    public ExecutionParameterRequest(String commandLine, String hostId, Map<String, Set<String>> parameters) {
        this.commandLine = commandLine;
        this.hostId = hostId;
        this.parameters = parameters;
    }

    public Map<String, Set<String>> getParameters() {
        return parameters;
    }

    public String getHostId() {
        return hostId;
    }

    public String getCommandLine() {
        return commandLine;
    }

    public boolean hasParameters() {
        return parameters != null && !parameters.isEmpty();
    }

    public boolean isExecutable() {
        return !Strings.isNullOrEmpty(commandLine) && hostId != null;
    }
}
