/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.plain.BytesValuesWithOrdinalsTermsEnum;

public abstract class BytesValues {
    public static final BytesValues EMPTY = new Empty();
    private final boolean multiValued;

    protected BytesValues(boolean multiValued) {
        this.multiValued = multiValued;
    }

    public final boolean isMultiValued() {
        return this.multiValued;
    }

    public abstract int setDocument(int var1);

    public abstract BytesRef nextValue();

    public AtomicFieldData.Order getOrder() {
        return AtomicFieldData.Order.BYTES;
    }

    private static final class Empty
    extends BytesValues {
        Empty() {
            super(false);
        }

        @Override
        public int setDocument(int docId) {
            return 0;
        }

        @Override
        public BytesRef nextValue() {
            throw new ElasticsearchIllegalStateException("Empty BytesValues has no next value");
        }
    }

    public static abstract class WithOrdinals
    extends BytesValues {
        public static final long MIN_ORDINAL = 0L;
        public static final long MISSING_ORDINAL = -1L;

        protected WithOrdinals(boolean multiValued) {
            super(multiValued);
        }

        public abstract long getMaxOrd();

        public abstract long getOrd(int var1);

        public abstract long nextOrd();

        public abstract BytesRef getValueByOrd(long var1);

        @Override
        public BytesRef nextValue() {
            return this.getValueByOrd(this.nextOrd());
        }

        public TermsEnum getTermsEnum() {
            return new BytesValuesWithOrdinalsTermsEnum(this);
        }
    }
}

