/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import de.schlichtherle.truezip.io.InputException;
import de.schlichtherle.truezip.util.ThreadGroups;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.ThreadSafe;

@DefaultAnnotation(value={NonNull.class})
@ThreadSafe
public final class Streams {
    private static final int FIFO_SIZE = 4;
    public static final int BUFFER_SIZE = 8192;
    private static final ExecutorService executor = Executors.newCachedThreadPool(new ReaderFactory());

    private Streams() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        try {
            Streams.cat(in, out);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                throw new InputException(ex);
            }
            finally {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cat(final InputStream in, OutputStream out) throws IOException {
        if (null == in || null == out) {
            throw new NullPointerException();
        }
        final Buffer[] buffers = Buffer.allocate();
        try {
            class Reader
            implements Runnable {
                int off;
                int size;
                volatile InputException exception;

                Reader() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int read;
                    InputStream _in = in;
                    Buffer[] _buffers = buffers;
                    int _buffersLen = buffers.length;
                    do {
                        Buffer buffer;
                        Reader reader = this;
                        synchronized (reader) {
                            while (this.size >= _buffersLen) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interrupted) {
                                    return;
                                }
                            }
                            buffer = _buffers[(this.off + this.size) % _buffersLen];
                        }
                        byte[] buf = buffer.buf;
                        try {
                            read = _in.read(buf, 0, buf.length);
                        }
                        catch (Throwable ex) {
                            this.exception = new InputException(ex);
                            read = -1;
                        }
                        buffer.read = read;
                        Reader reader2 = this;
                        synchronized (reader2) {
                            ++this.size;
                            this.notify();
                        }
                    } while (read != -1);
                }
            }
            Reader reader = new Reader();
            Future<?> task = executor.submit(reader);
            int buffersLen = buffers.length;
            while (true) {
                Buffer buffer;
                int off;
                Reader reader2 = reader;
                synchronized (reader2) {
                    while (reader.size <= 0) {
                        try {
                            reader.wait();
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(Streams.class.getName()).log(Level.FINE, ex.getLocalizedMessage(), ex);
                        }
                    }
                    off = reader.off;
                    buffer = buffers[off];
                }
                int write = buffer.read;
                if (write == -1) break;
                byte[] buf = buffer.buf;
                try {
                    out.write(buf, 0, write);
                }
                catch (IOException ex) {
                    task.cancel(true);
                    while (true) {
                        try {
                            task.get();
                        }
                        catch (CancellationException ex2) {
                        }
                        catch (ExecutionException ex2) {
                            throw new AssertionError((Object)ex2);
                        }
                        catch (InterruptedException ex2) {
                            Logger.getLogger(Streams.class.getName()).log(Level.FINE, ex2.getLocalizedMessage(), ex2);
                            continue;
                        }
                        break;
                    }
                    throw ex;
                }
                Reader reader3 = reader;
                synchronized (reader3) {
                    reader.off = (off + 1) % buffersLen;
                    --reader.size;
                    reader.notify();
                }
            }
            out.flush();
            if (reader.exception != null) {
                throw reader.exception;
            }
        }
        finally {
            Buffer.release(buffers);
        }
    }

    public static final class Reader
    extends Thread {
        Reader(Runnable r) {
            super(ThreadGroups.getTopLevel(), r, Reader.class.getName());
            this.setDaemon(true);
        }
    }

    private static final class ReaderFactory
    implements ThreadFactory {
        private ReaderFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Reader(r);
        }
    }

    private static final class Buffer {
        static final List<Reference<Buffer[]>> list = new LinkedList<Reference<Buffer[]>>();
        final byte[] buf = new byte[8192];
        int read;

        private Buffer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Buffer[] allocate() {
            Class<Buffer> clazz = Buffer.class;
            synchronized (Buffer.class) {
                Iterator<Reference<Buffer[]>> i = list.iterator();
                while (i.hasNext()) {
                    Buffer[] buffers = i.next().get();
                    i.remove();
                    if (null == buffers) continue;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return buffers;
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                Buffer[] buffers = new Buffer[4];
                int i2 = buffers.length;
                while (--i2 >= 0) {
                    buffers[i2] = new Buffer();
                }
                return buffers;
            }
        }

        static synchronized void release(Buffer[] buffers) {
            list.add(new SoftReference<Buffer[]>(buffers));
        }
    }
}

