/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.service.replacement;

import com.xebialabs.deployit.engine.replacer.PlaceholderScanner;
import com.xebialabs.deployit.engine.replacer.ScanningMap;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.service.replacement.MustachePlaceholders;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class MustachePlaceholderScanner
implements PlaceholderScanner {
    public Set<String> scan(String in) {
        ScanningMap context = new ScanningMap();
        MustachePlaceholders.newMustacheCompiler().compile(in).execute((Object)context, (Writer)new DiscardingWriter());
        return context.keySet();
    }

    public Set<String> scan(Reader in) {
        return this.scan(in, "{{ }}");
    }

    public Set<String> scan(Reader in, String delimiters) {
        ScanningMap context = new ScanningMap();
        MustachePlaceholders.newMustacheCompiler().withDelims(delimiters).compile(in).execute((Object)context, (Writer)new DiscardingWriter());
        return context.keySet();
    }

    public static boolean hasPlaceholders(String value) {
        return !new MustachePlaceholderScanner().scan(value).isEmpty();
    }

    public static boolean hasPlaceholders(Object deployableValue, PropertyDescriptor deployablePropDesc) {
        switch (deployablePropDesc.getKind()) {
            case BOOLEAN: 
            case INTEGER: 
            case ENUM: 
            case DATE: 
            case CI: 
            case SET_OF_CI: 
            case LIST_OF_CI: {
                break;
            }
            case STRING: {
                return MustachePlaceholderScanner.hasPlaceholders((String)deployableValue);
            }
            case SET_OF_STRING: 
            case LIST_OF_STRING: {
                for (String s : (Collection)deployableValue) {
                    if (!MustachePlaceholderScanner.hasPlaceholders(s)) continue;
                    return true;
                }
                break;
            }
            case MAP_STRING_STRING: {
                for (String s : ((Map)deployableValue).values()) {
                    if (!MustachePlaceholderScanner.hasPlaceholders(s)) continue;
                    return true;
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown property type: " + deployablePropDesc.getKind());
            }
        }
        return false;
    }

    private static class DiscardingWriter
    extends Writer {
        private DiscardingWriter() {
        }

        @Override
        public void write(char[] chars, int i, int i1) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

