/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.utils.glob;

import com.google.common.base.Preconditions;
import com.xebialabs.overthere.OverthereFile;
import java.util.Date;
import org.springframework.util.AntPathMatcher;

public class FileMatcher {
    private final String pattern;
    private Date lastModifiedDateAfter;
    private AntPathMatcher pathMatcher = new AntPathMatcher();

    public FileMatcher(String pattern) {
        Preconditions.checkNotNull((Object)pattern, (Object)"A Ant style pattern is required");
        this.pattern = pattern;
    }

    public FileMatcher withLastModifiedDateAfter(Date modifiedDate) {
        this.lastModifiedDateAfter = modifiedDate;
        return this;
    }

    public boolean match(OverthereFile file) {
        boolean matched = true;
        matched &= this.pathMatcher.match(this.pattern, file.getPath());
        if (this.lastModifiedDateAfter != null) {
            matched = matched && file.lastModified() > this.lastModifiedDateAfter.getTime();
        }
        return matched;
    }

    public boolean match(String filePath) {
        return this.pathMatcher.match(this.pattern, filePath);
    }
}

