/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltest.resources;

import com.jayway.jsonpath.spi.JsonProviderFactory;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.xltest.domain.Report;
import com.xebialabs.xltest.domain.TestRun;
import com.xebialabs.xltest.repository.NotFoundException;
import com.xebialabs.xltest.repository.TestRunsRepository;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/reports")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class ReportController {
    private static final Logger LOG = LoggerFactory.getLogger(ReportController.class);
    private final RepositoryService repositoryService;
    private final TestRunsRepository testRunsRepository;
    private final AutowireCapableBeanFactory beanFactory;

    @Autowired
    public ReportController(RepositoryService repositoryService, TestRunsRepository testRunsRepository, AutowireCapableBeanFactory beanFactory) {
        this.repositoryService = repositoryService;
        this.testRunsRepository = testRunsRepository;
        this.beanFactory = beanFactory;
    }

    @GET
    @Path(value="/{testRunId:[\\w-]+}")
    public Collection<Report> getReports(@PathParam(value="testRunId") String testRunId, @Context HttpServletResponse response) throws IOException {
        try {
            TestRun testRun = this.testRunsRepository.getTestRun(UUID.fromString(testRunId));
            List<Report> reports = this.findReportForTestSetDefinitionType();
            if (reports != null && !reports.isEmpty()) {
                return reports;
            }
            response.sendError(404, "Can't find any Report associated to test runs of: " + testRun.getId());
            return null;
        }
        catch (NotFoundException e) {
            response.sendError(404, "Can't find test run");
            return null;
        }
    }

    private List<Report> findReportForTestSetDefinitionType() {
        SearchParameters query = new SearchParameters().setType(Type.valueOf(Report.class));
        List reportCis = this.repositoryService.listEntities(query);
        return reportCis;
    }

    @GET
    @Path(value="/{testRunId:[\\w-]+}/Configuration/Reports/{reportName:.*}")
    public String generateReport(@PathParam(value="testRunId") String testRunId, @PathParam(value="reportName") String reportName, @Context UriInfo uriInfo) throws IOException {
        Report report = (Report)this.repositoryService.read("Configuration/Reports/" + reportName);
        LOG.info("Found report with value {}", (Object)report);
        Map<String, Object> resultObject = this.generateReport(UUID.fromString(testRunId), report, this.convertMultivaluedMapToMap((MultivaluedMap<String, String>)uriInfo.getQueryParameters()));
        return JsonProviderFactory.createProvider().toJson(resultObject);
    }

    @GET
    @Path(value="/{reportName}/testspecification/{testSpecificationName:.*}")
    public Response generateReportFromTestSpecification(@PathParam(value="testSpecificationName") String testSpecificationName, @PathParam(value="reportName") String reportName, @Context UriInfo uriInfo) throws IOException {
        UUID testRunId = this.findLastRunOf(testSpecificationName);
        if (testRunId == null) {
            return Response.noContent().build();
        }
        Report report = (Report)this.repositoryService.read("Configuration/Reports/" + reportName);
        Map<String, Object> resultObject = this.generateReport(testRunId, report, this.convertMultivaluedMapToMap((MultivaluedMap<String, String>)uriInfo.getQueryParameters()));
        return Response.ok((Object)JsonProviderFactory.createProvider().toJson(resultObject)).build();
    }

    private UUID findLastRunOf(String testSpecificationName) {
        TestRun lastTestRun = null;
        for (TestRun testRun : this.testRunsRepository.getAllTestRuns()) {
            if (!testRun.getTestSpecificationName().equals(testSpecificationName)) continue;
            if (lastTestRun == null) {
                lastTestRun = testRun;
                continue;
            }
            if (!testRun.getStartTime().after(lastTestRun.getStartTime())) continue;
            lastTestRun = testRun;
        }
        return lastTestRun == null ? null : lastTestRun.getTestRunId();
    }

    @POST
    @Path(value="/{testRunId:.+}")
    public String generateReport(@PathParam(value="testRunId") String testRunId, Report report, @Context UriInfo uriInfo) {
        Map<String, Object> resultObject = this.generateReport(UUID.fromString(testRunId), report, this.convertMultivaluedMapToMap((MultivaluedMap<String, String>)uriInfo.getQueryParameters()));
        return JsonProviderFactory.createProvider().toJson(resultObject);
    }

    private Map<String, String> convertMultivaluedMapToMap(MultivaluedMap<String, String> multivaluedMap) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String key : multivaluedMap.keySet()) {
            map.put(key, (String)multivaluedMap.getFirst((Object)key));
        }
        return map;
    }

    private Map<String, Object> generateReport(UUID testRunId, Report report, Map<String, String> queryParameters) {
        TestRun run = this.testRunsRepository.getTestRun(testRunId);
        return this.generateReport(run, report, queryParameters);
    }

    private Map<String, Object> generateReport(TestRun testRun, Report report, Map<String, String> queryParameters) {
        if (report != null) {
            this.beanFactory.autowireBean((Object)report);
            report.addAttribute("queryParameters", queryParameters);
            report.addAttribute("startDate", this.testRunsRepository.makeStartDateIfProvided(queryParameters.get("startDate")));
            report.addAttribute("endDate", this.testRunsRepository.makeEndDateIfProvided(queryParameters.get("endDate")));
            TreeMap<String, Object> resultObject = new TreeMap<String, Object>();
            resultObject.put("type", report.getReportType().toLowerCase());
            resultObject.put("report", report.compute(testRun));
            return resultObject;
        }
        return Collections.emptyMap();
    }
}

