/*
 * Decompiled with CFR 0.152.
 */
package fitnesseMain;

import fitnesse.ConfigurationParameter;
import fitnesse.ContextConfigurator;
import fitnesse.FitNesse;
import fitnesse.FitNesseContext;
import fitnesse.components.PluginsClassLoader;
import fitnesse.reporting.ExitCodeListener;
import fitnesse.updates.UpdaterImplementation;
import fitnesseMain.Arguments;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class FitNesseMain {
    private static final Logger LOG = Logger.getLogger(FitNesseMain.class.getName());
    private final ExitCodeListener exitCodeListener = new ExitCodeListener();

    public static void main(String[] args) throws Exception {
        Arguments arguments = null;
        try {
            arguments = new Arguments(args);
        }
        catch (IllegalArgumentException e) {
            Arguments.printUsage();
            FitNesseMain.exit(1);
        }
        Integer exitCode = new FitNesseMain().launchFitNesse(arguments);
        if (exitCode != null) {
            FitNesseMain.exit(exitCode);
        }
    }

    protected static void exit(int exitCode) {
        System.exit(exitCode);
    }

    public Integer launchFitNesse(Arguments arguments) throws Exception {
        ContextConfigurator contextConfigurator = ContextConfigurator.systemDefaults();
        contextConfigurator = contextConfigurator.updatedWith(System.getProperties());
        contextConfigurator = contextConfigurator.updatedWith(ConfigurationParameter.loadProperties(new File(arguments.getConfigFile(contextConfigurator))));
        contextConfigurator = arguments.update(contextConfigurator);
        return this.launchFitNesse(contextConfigurator);
    }

    public Integer launchFitNesse(ContextConfigurator contextConfigurator) throws Exception {
        this.configureLogging("verbose".equalsIgnoreCase(contextConfigurator.get(ConfigurationParameter.LOG_LEVEL)));
        this.loadPlugins(contextConfigurator.get(ConfigurationParameter.ROOT_PATH));
        if (contextConfigurator.get(ConfigurationParameter.COMMAND) != null) {
            contextConfigurator.withTestSystemListener(this.exitCodeListener);
        }
        FitNesseContext context = contextConfigurator.makeFitNesseContext();
        this.logStartupInfo(context);
        this.update(context);
        if ("true".equalsIgnoreCase(contextConfigurator.get(ConfigurationParameter.INSTALL_ONLY))) {
            return null;
        }
        return this.launch(context);
    }

    private boolean update(FitNesseContext context) throws IOException {
        if (!"true".equalsIgnoreCase(context.getProperty(ConfigurationParameter.OMITTING_UPDATES.getKey()))) {
            UpdaterImplementation updater = new UpdaterImplementation(context);
            return updater.update();
        }
        return false;
    }

    private void loadPlugins(String rootPath) throws Exception {
        new PluginsClassLoader(rootPath).addPluginsToClassLoader();
    }

    private Integer launch(FitNesseContext context) throws Exception {
        if (!"true".equalsIgnoreCase(context.getProperty(ConfigurationParameter.INSTALL_ONLY.getKey()))) {
            String command = context.getProperty(ConfigurationParameter.COMMAND.getKey());
            if (command != null) {
                String output = context.getProperty(ConfigurationParameter.OUTPUT.getKey());
                this.executeSingleCommand(context.fitNesse, command, output);
                return this.exitCodeListener.getFailCount();
            }
            context.fitNesse.start();
        }
        return null;
    }

    private void executeSingleCommand(FitNesse fitNesse, String command, String outputFile) throws Exception {
        OutputStream os;
        boolean outputRedirectedToFile;
        LOG.info("Executing command: " + command);
        boolean bl = outputRedirectedToFile = outputFile != null;
        if (outputRedirectedToFile) {
            LOG.info("-----Command Output redirected to " + outputFile + "-----");
            os = new FileOutputStream(outputFile);
        } else {
            LOG.info("-----Command Output-----");
            os = System.out;
        }
        fitNesse.executeSingleCommand(command, os);
        fitNesse.stop();
        if (outputRedirectedToFile) {
            ((OutputStream)os).close();
        } else {
            LOG.info("-----Command Complete-----");
        }
    }

    private void logStartupInfo(FitNesseContext context) {
        System.out.println("Bootstrapping FitNesse, the fully integrated standalone wiki and acceptance testing framework.");
        LOG.info("root page: " + context.root);
        LOG.info("logger: " + (context.logger == null ? "none" : context.logger.toString()));
        LOG.info("authenticator: " + context.authenticator);
        LOG.info("page factory: " + context.pageFactory);
        LOG.info("page theme: " + context.pageFactory.getTheme());
        LOG.info("Starting FitNesse on port: " + context.port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureLogging(boolean verbose) {
        if (this.loggingSystemPropertiesDefined()) {
            return;
        }
        InputStream in = FitNesseMain.class.getResourceAsStream((verbose ? "verbose-" : "") + "logging.properties");
        try {
            LogManager.getLogManager().readConfiguration(in);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Log configuration failed", e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Unable to close Log configuration file", e);
                }
            }
        }
        LOG.finest("Configured verbose logging");
    }

    private boolean loggingSystemPropertiesDefined() {
        return System.getProperty("java.util.logging.config.class") != null || System.getProperty("java.util.logging.config.file") != null;
    }
}

