/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.search;

import fitnesse.components.TraversalListener;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageType;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.search.WikiPageFinder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AttributeWikiPageFinder
extends WikiPageFinder {
    private static final List<String> setUpPageNames = Arrays.asList("SetUp", "SuiteSetUp");
    private static final List<String> tearDownPageNames = Arrays.asList("TearDown", "SuiteTearDown");
    private List<PageType> requestedPageTypes;
    private Map<String, Boolean> attributes;
    private List<String> suites;

    private static List<String> splitSuitesIntoArray(String suitesInput) {
        if (suitesInput == null) {
            return null;
        }
        if (AttributeWikiPageFinder.isEmpty(suitesInput)) {
            return Collections.emptyList();
        }
        return Arrays.asList(suitesInput.split("\\s*,\\s*"));
    }

    private static boolean isEmpty(String checkedString) {
        for (char character : checkedString.toCharArray()) {
            if (Character.isWhitespace(character)) continue;
            return false;
        }
        return true;
    }

    public AttributeWikiPageFinder(TraversalListener<? super WikiPage> observer, List<PageType> requestedPageTypes, Map<String, Boolean> attributes, List<String> suites) {
        super(observer);
        this.requestedPageTypes = requestedPageTypes;
        this.attributes = attributes;
        this.suites = suites;
    }

    public AttributeWikiPageFinder(TraversalListener<? super WikiPage> observer, List<PageType> pageTypes, Map<String, Boolean> attributes, String suites) {
        this(observer, pageTypes, attributes, AttributeWikiPageFinder.splitSuitesIntoArray(suites));
    }

    @Override
    protected boolean pageMatches(WikiPage page) {
        if (!this.meetsSetUpTearDownConditions(page)) {
            return false;
        }
        PageData pageData = page.getData();
        if (!this.pageIsOfRequestedPageType(page, this.requestedPageTypes)) {
            return false;
        }
        for (Map.Entry<String, Boolean> input : this.attributes.entrySet()) {
            if ("SetUp".equals(input.getKey()) || "TearDown".equals(input.getKey()) || this.attributeMatchesInput(pageData.hasAttribute(input.getKey()), input.getValue())) continue;
            return false;
        }
        return this.suitesMatchInput(pageData, this.suites);
    }

    private boolean meetsSetUpTearDownConditions(WikiPage page) {
        if (this.attributes.containsKey("SetUp") && this.attributes.containsKey("TearDown")) {
            Boolean setupWanted = this.attributes.get("SetUp");
            Boolean teardownWanted = this.attributes.get("TearDown");
            if (setupWanted.booleanValue() && teardownWanted.booleanValue()) {
                return this.isSetUpPage(page) || this.isTearDownPage(page);
            }
            return this.isSetUpPage(page) == setupWanted.booleanValue() && this.isTearDownPage(page) == teardownWanted.booleanValue();
        }
        if (this.attributes.containsKey("SetUp")) {
            return this.isSetUpPage(page) == this.attributes.get("SetUp").booleanValue();
        }
        if (this.attributes.containsKey("TearDown")) {
            return this.isTearDownPage(page) == this.attributes.get("TearDown").booleanValue();
        }
        return true;
    }

    private boolean isTearDownPage(WikiPage page) {
        return tearDownPageNames.contains(page.getName());
    }

    private boolean isSetUpPage(WikiPage page) {
        return setUpPageNames.contains(page.getName());
    }

    private boolean pageIsOfRequestedPageType(WikiPage page, List<PageType> requestedPageTypesEnum) {
        if (requestedPageTypesEnum == null || requestedPageTypesEnum.isEmpty()) {
            return true;
        }
        PageType pageType = PageType.fromWikiPage(page);
        return requestedPageTypesEnum.contains((Object)pageType);
    }

    protected boolean attributeMatchesInput(boolean attributeSet, boolean inputValueOn) {
        return !inputValueOn || attributeSet == inputValueOn;
    }

    private boolean suitesMatchInput(PageData pageData, List<String> suites) {
        if (suites == null) {
            return true;
        }
        List<String> suitesProperty = AttributeWikiPageFinder.splitSuitesIntoArray(pageData.getAttribute("Suites"));
        if (suites.isEmpty() != this.isEmptyOrNull(suitesProperty)) {
            return false;
        }
        for (String suite : suites) {
            if (suitesProperty.contains(suite)) continue;
            return false;
        }
        return true;
    }

    private boolean isEmptyOrNull(List<String> stringList) {
        return stringList == null || stringList.isEmpty();
    }
}

