/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.fs;

import fitnesse.wiki.NoSuchVersionException;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiImportProperty;
import fitnesse.wiki.fs.DiskFileSystem;
import fitnesse.wiki.fs.FileSystemPage;
import fitnesse.wiki.fs.FileVersion;
import fitnesse.wiki.fs.SimpleFileVersionsController;
import fitnesse.wiki.fs.VersionsController;
import fitnesse.wiki.fs.ZipFileVersionInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import util.FileUtil;

public class ZipFileVersionsController
implements VersionsController {
    private static final Logger LOG = Logger.getLogger(ZipFileVersionsController.class.getName());
    public static final Pattern ZIP_FILE_PATTERN = Pattern.compile("(\\S+)?\\d+(~\\d+)?\\.zip");
    private int daysTillVersionsExpire = 14;
    private VersionsController persistence = new SimpleFileVersionsController(new DiskFileSystem());

    @Override
    public void setHistoryDepth(int historyDepth) {
        this.daysTillVersionsExpire = historyDepth;
    }

    @Override
    public FileVersion[] getRevisionData(String label, File ... files) {
        if (label == null) {
            return this.persistence.getRevisionData(null, files);
        }
        File file = new File(files[0].getParentFile(), label + ".zip");
        if (!file.exists()) {
            throw new NoSuchVersionException("There is no version '" + label + "'");
        }
        ZipFile zipFile = null;
        FileVersion[] versions = new FileVersion[files.length];
        int counter = 0;
        try {
            zipFile = new ZipFile(file);
            for (File f : files) {
                ZipFileVersion version = this.loadZipEntry(zipFile, f);
                if (version == null) continue;
                versions[counter++] = version;
            }
            Object[] arr$ = versions;
            return arr$;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Unable to read zip file contents", e);
            }
        }
    }

    public Collection<ZipFileVersionInfo> history(File ... files) {
        return this.history(files[0].getParentFile());
    }

    public Collection<ZipFileVersionInfo> history(File dir) {
        File[] files = dir.listFiles();
        HashSet<ZipFileVersionInfo> versions = new HashSet<ZipFileVersionInfo>();
        if (files != null) {
            for (File file : files) {
                if (!this.isVersionFile(file)) continue;
                versions.add(ZipFileVersionInfo.makeVersionInfo(file));
            }
        }
        return versions;
    }

    @Override
    public VersionInfo makeVersion(FileVersion ... fileVersions) throws IOException {
        this.makeZipVersion(fileVersions);
        return this.persistence.makeVersion(fileVersions);
    }

    @Override
    public VersionInfo addDirectory(FileVersion filePath) throws IOException {
        return this.persistence.addDirectory(filePath);
    }

    @Override
    public void rename(FileVersion fileVersion, File originalFile) throws IOException {
        this.persistence.rename(fileVersion, originalFile);
    }

    @Override
    public void delete(FileVersion ... files) {
        this.persistence.delete(files);
    }

    protected void makeZipVersion(FileVersion ... fileVersions) {
        if (!this.exists(fileVersions)) {
            return;
        }
        ZipOutputStream zos = null;
        File commonBaseDir = this.commonBaseDir(fileVersions);
        try {
            File zipFile = this.makeVersionFileName(commonBaseDir, this.makeVersionName(fileVersions[0]));
            zos = new ZipOutputStream(new FileOutputStream(zipFile));
            for (FileVersion fileVersion : fileVersions) {
                this.addToZip(fileVersion.getFile(), zos);
            }
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
        finally {
            try {
                if (zos != null) {
                    zos.finish();
                    zos.close();
                }
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Unable to create zip file", e);
            }
            this.pruneVersions(this.history(commonBaseDir));
        }
    }

    private String makeVersionName(FileVersion fileVersion) {
        Date time = fileVersion.getLastModificationTime();
        String versionName = WikiImportProperty.getTimeFormat().format(time);
        String user = fileVersion.getAuthor();
        if (user != null && !"".equals(user)) {
            versionName = user + "-" + versionName;
        }
        return versionName;
    }

    private boolean exists(FileVersion[] fileVersions) {
        for (FileVersion fileVersion : fileVersions) {
            if (!fileVersion.getFile().exists()) continue;
            return true;
        }
        return false;
    }

    private File commonBaseDir(FileVersion[] fileVersions) {
        return fileVersions[0].getFile().getParentFile();
    }

    private void addToZip(File file, ZipOutputStream zos) throws IOException {
        ZipEntry entry = new ZipEntry(file.getName());
        zos.putNextEntry(entry);
        FileInputStream is = new FileInputStream(file);
        int size = (int)file.length();
        byte[] bytes = new byte[size];
        is.read(bytes);
        is.close();
        zos.write(bytes, 0, size);
    }

    private boolean isVersionFile(File file) {
        return ZIP_FILE_PATTERN.matcher(file.getName()).matches();
    }

    private ZipFileVersion loadZipEntry(ZipFile zipFile, File file) {
        ZipEntry contentEntry = zipFile.getEntry(file.getName());
        if (contentEntry != null) {
            InputStream contentIS = null;
            try {
                contentIS = zipFile.getInputStream(contentEntry);
                ZipFileVersion zipFileVersion = new ZipFileVersion(file, FileUtil.toString(contentIS), new Date(contentEntry.getTime()));
                return zipFileVersion;
            }
            catch (Throwable th) {
                throw new RuntimeException(th);
            }
            finally {
                try {
                    if (contentIS != null) {
                        contentIS.close();
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Unable to read zip file contents", e);
                }
            }
        }
        return null;
    }

    private Collection<VersionInfo> loadVersions(FileSystemPage page) {
        File dir = page.getFileSystemPath();
        File[] files = dir.listFiles();
        HashSet<VersionInfo> versions = new HashSet<VersionInfo>();
        if (files != null) {
            for (File file : files) {
                if (!this.isVersionFile(file)) continue;
                versions.add(ZipFileVersionInfo.makeVersionInfo(file));
            }
        }
        return versions;
    }

    private File makeVersionFileName(File file, String name) {
        File zipFile = new File(file, name + ".zip");
        int counter = 1;
        while (zipFile.exists()) {
            zipFile = new File(file, name + "~" + counter++ + ".zip");
        }
        return zipFile;
    }

    private void pruneVersions(Collection<ZipFileVersionInfo> versions) {
        List<ZipFileVersionInfo> versionsList = this.makeSortedVersionList(versions);
        if (versions.size() > 0) {
            VersionInfo lastVersion = versionsList.get(versionsList.size() - 1);
            Date expirationDate = this.makeVersionExpirationDate(lastVersion);
            for (ZipFileVersionInfo version : versionsList) {
                Date thisDate = version.getCreationTime();
                if (!thisDate.before(expirationDate) && !thisDate.equals(expirationDate)) continue;
                version.getFile().delete();
            }
        }
    }

    private List<ZipFileVersionInfo> makeSortedVersionList(Collection<ZipFileVersionInfo> versions) {
        ArrayList<ZipFileVersionInfo> versionsList = new ArrayList<ZipFileVersionInfo>(versions);
        Collections.sort(versionsList);
        return versionsList;
    }

    private Date makeVersionExpirationDate(VersionInfo lastVersion) {
        Date dateOfLastVersion = lastVersion.getCreationTime();
        GregorianCalendar expirationDate = new GregorianCalendar();
        expirationDate.setTime(dateOfLastVersion);
        expirationDate.add(5, -this.daysTillVersionsExpire);
        return expirationDate.getTime();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private static class ZipFileVersion
    implements FileVersion {
        private final File file;
        private final String content;
        private final Date lastModified;

        public ZipFileVersion(File file, String content, Date lastModified) {
            this.file = file;
            this.content = content;
            this.lastModified = lastModified;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public InputStream getContent() throws IOException {
            return new ByteArrayInputStream(this.content.getBytes("UTF-8"));
        }

        @Override
        public String getAuthor() {
            return null;
        }

        @Override
        public Date getLastModificationTime() {
            return this.lastModified;
        }
    }
}

