/*
 * Decompiled with CFR 0.152.
 */
package fitnesse.wiki.fs;

import fitnesse.wiki.BaseWikiPage;
import fitnesse.wiki.PageData;
import fitnesse.wiki.PageType;
import fitnesse.wiki.VersionInfo;
import fitnesse.wiki.WikiPage;
import fitnesse.wiki.WikiPagePath;
import fitnesse.wiki.WikiPageProperties;
import fitnesse.wiki.fs.FileVersion;
import fitnesse.wiki.fs.SubWikiPageFactory;
import fitnesse.wiki.fs.VersionsController;
import fitnesse.wikitext.parser.VariableSource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import util.Clock;
import util.FileUtil;

public class FileSystemPage
extends BaseWikiPage {
    private static final long serialVersionUID = 1L;
    static final String contentFilename = "content.txt";
    static final String propertiesFilename = "properties.xml";
    private final File path;
    private final transient VersionsController versionsController;
    private final transient SubWikiPageFactory subWikiPageFactory;
    private final String versionName;
    private transient PageData pageData;

    public FileSystemPage(File path, String name, VersionsController versionsController, SubWikiPageFactory subWikiPageFactory, VariableSource variableSource) {
        super(name, variableSource);
        this.path = path;
        this.versionsController = versionsController;
        this.subWikiPageFactory = subWikiPageFactory;
        this.versionName = null;
    }

    public FileSystemPage(File path, String name, FileSystemPage parent) {
        this(path, name, parent, null, parent.versionsController, parent.subWikiPageFactory, parent.getVariableSource());
    }

    public FileSystemPage(File path, String name, FileSystemPage parent, VersionsController versionsController) {
        this(path, name, parent, null, versionsController, parent.subWikiPageFactory, parent.getVariableSource());
    }

    private FileSystemPage(FileSystemPage page, String versionName) {
        this(page.getFileSystemPath(), page.getName(), (FileSystemPage)(page.isRoot() ? null : page.getParent()), versionName, page.versionsController, page.subWikiPageFactory, page.getVariableSource());
    }

    private FileSystemPage(File path, String name, FileSystemPage parent, String versionName, VersionsController versionsController, SubWikiPageFactory subWikiPageFactory, VariableSource variableSource) {
        super(name, parent, variableSource);
        this.path = path;
        this.versionsController = versionsController;
        this.subWikiPageFactory = subWikiPageFactory;
        this.versionName = versionName;
    }

    @Override
    public boolean hasChildPage(String pageName) {
        return this.subWikiPageFactory.getChildPage(this, pageName) != null;
    }

    @Override
    public void removeChildPage(String name) {
        final WikiPage childPage = this.getChildPage(name);
        if (childPage instanceof FileSystemPage) {
            this.versionsController.delete(new FileVersion(){

                @Override
                public File getFile() {
                    return ((FileSystemPage)childPage).getFileSystemPath();
                }

                @Override
                public InputStream getContent() throws IOException {
                    return null;
                }

                @Override
                public String getAuthor() {
                    return "";
                }

                @Override
                public Date getLastModificationTime() {
                    return new Date();
                }
            });
        }
    }

    @Override
    public WikiPage addChildPage(String pageName) {
        WikiPage page = this.getChildPage(pageName);
        if (page == null) {
            page = new FileSystemPage(new File(this.getFileSystemPath(), pageName), pageName, this);
        }
        return page;
    }

    @Override
    public List<WikiPage> getChildren() {
        return this.subWikiPageFactory.getChildren(this);
    }

    @Override
    public WikiPage getChildPage(String childName) {
        return this.subWikiPageFactory.getChildPage(this, childName);
    }

    @Override
    public PageData getData() {
        if (this.pageData == null) {
            this.pageData = this.getDataVersion();
        }
        return new PageData(this.pageData);
    }

    public File getFileSystemPath() {
        return this.path;
    }

    @Override
    public VersionInfo commit(PageData data) {
        this.resetCache();
        try {
            return this.versionsController.makeVersion(new ContentFileVersion(data), new PropertiesFileVersion(data));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void resetCache() {
        super.resetCache();
        this.pageData = null;
    }

    @Override
    public Collection<VersionInfo> getVersions() {
        return this.versionsController.history(this.contentFile(), this.propertiesFile());
    }

    private PageData getDataVersion() {
        FileVersion[] versions = this.versionsController.getRevisionData(this.versionName, this.contentFile(), this.propertiesFile());
        String content = "";
        WikiPageProperties properties = null;
        try {
            for (FileVersion version : versions) {
                if (version == null) continue;
                if (contentFilename.equals(version.getFile().getName())) {
                    content = this.loadContent(version);
                    continue;
                }
                if (!propertiesFilename.equals(version.getFile().getName())) continue;
                properties = this.loadAttributes(version);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (properties == null) {
            properties = this.defaultPageProperties();
        }
        return new PageData(content, properties);
    }

    public WikiPageProperties defaultPageProperties() {
        WikiPageProperties properties = new WikiPageProperties();
        if (!this.isErrorLogsPage()) {
            properties.set("Edit");
            properties.set("Properties");
            properties.set("Refactor");
        }
        properties.set("WhereUsed");
        properties.set("RecentChanges");
        properties.set("Files");
        properties.set("Versions");
        properties.set("Search");
        properties.setLastModificationTime(Clock.currentDate());
        if (this.isErrorLogsPage()) {
            return properties;
        }
        PageType pageType = PageType.getPageTypeForPageName(this.getName());
        if (PageType.STATIC.equals((Object)pageType)) {
            return properties;
        }
        properties.set(pageType.toString());
        return properties;
    }

    private boolean isErrorLogsPage() {
        WikiPagePath pagePath = this.getPageCrawler().getFullPath();
        return "ErrorLogs".equals(pagePath.getFirst());
    }

    @Override
    public WikiPage getVersion(String versionName) {
        this.versionsController.getRevisionData(versionName, this.contentFile(), this.propertiesFile());
        return new FileSystemPage(this, versionName);
    }

    @Override
    public String toString() {
        try {
            return this.getClass().getName() + " at " + this.getFileSystemPath() + "#" + (this.versionName != null ? this.versionName : "latest");
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    private File contentFile() {
        return new File(this.getFileSystemPath(), contentFilename);
    }

    private File propertiesFile() {
        return new File(this.getFileSystemPath(), propertiesFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadContent(FileVersion fileVersion) throws IOException {
        InputStream content = fileVersion.getContent();
        try {
            String string = FileUtil.toString(content);
            return string;
        }
        finally {
            content.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WikiPageProperties loadAttributes(FileVersion fileVersion) throws IOException {
        WikiPageProperties props = new WikiPageProperties();
        InputStream content = fileVersion.getContent();
        try {
            props.loadFromXmlStream(content);
        }
        finally {
            content.close();
        }
        props.setLastModificationTime(fileVersion.getLastModificationTime());
        return props;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileSystemPage)) {
            return false;
        }
        FileSystemPage that = (FileSystemPage)o;
        if (this.versionName != null ? !this.versionName.equals(that.versionName) : that.versionName != null) {
            return false;
        }
        return super.equals(that);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.versionName != null ? this.versionName.hashCode() : 0);
        return result;
    }

    class PropertiesFileVersion
    implements FileVersion {
        final PageData data;

        PropertiesFileVersion(PageData pageData) {
            this.data = new PageData(pageData);
        }

        @Override
        public File getFile() {
            return FileSystemPage.this.propertiesFile();
        }

        @Override
        public InputStream getContent() throws IOException {
            WikiPageProperties propertiesToSave = new WikiPageProperties(this.data.getProperties());
            this.removeAlwaysChangingProperties(propertiesToSave);
            return new ByteArrayInputStream(propertiesToSave.toXml().getBytes("UTF-8"));
        }

        @Override
        public String getAuthor() {
            return this.data.getAttribute("LastModifyingUser");
        }

        @Override
        public Date getLastModificationTime() {
            return this.data.getProperties().getLastModificationTime();
        }

        private void removeAlwaysChangingProperties(WikiPageProperties properties) {
            properties.remove("LastModified");
        }
    }

    class ContentFileVersion
    implements FileVersion {
        final PageData data;

        ContentFileVersion(PageData pageData) {
            this.data = new PageData(pageData);
        }

        @Override
        public File getFile() {
            return FileSystemPage.this.contentFile();
        }

        @Override
        public InputStream getContent() throws UnsupportedEncodingException {
            String content = this.data.getContent();
            if (content == null) {
                return new ByteArrayInputStream("".getBytes());
            }
            String separator = System.getProperty("line.separator");
            if (content.endsWith("|")) {
                content = content + separator;
            }
            content = content.replaceAll("\r\n", "\n");
            content = content.replaceAll("\n", separator);
            return new ByteArrayInputStream(content.getBytes("UTF-8"));
        }

        @Override
        public String getAuthor() {
            return this.data.getAttribute("LastModifyingUser");
        }

        @Override
        public Date getLastModificationTime() {
            return this.data.getProperties().getLastModificationTime();
        }
    }
}

