/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.api.reflect;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistryId;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Prefix;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import java.util.Collection;
import java.util.Map;

@PublicApiRef
public abstract class DescriptorRegistry {
    private static final Map<DescriptorRegistryId, DescriptorRegistry> REGISTRIES = Maps.newLinkedHashMap();
    private final LoadingCache<String, Type> NAME_TYPE_CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Type>(){

        public Type load(String typeName) throws Exception {
            Preconditions.checkNotNull((Object)typeName, (Object)"Type name may not be null.");
            Preconditions.checkArgument((typeName.indexOf(46) != -1 ? 1 : 0) != 0, (String)"Type %s does not contain a prefix", (Object[])new Object[]{typeName});
            int indexOfLastDot = typeName.lastIndexOf(46);
            return DescriptorRegistry.this.lookupType(typeName.substring(0, indexOfLastDot), typeName.substring(indexOfLastDot + 1));
        }
    });
    private final LoadingCache<Class<?>, Type> CLASS_TYPE_CACHE = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Type>(){

        public Type load(Class<?> ciClass) throws Exception {
            Preconditions.checkNotNull(ciClass, (Object)"Type class may not be null.");
            Package ciPackage = ciClass.getPackage();
            Prefix prefix = ciPackage.getAnnotation(Prefix.class);
            Preconditions.checkNotNull((Object)prefix, (String)"Package [%s] should have an @Prefix annotation for ci-class [%s]", (Object[])new Object[]{ciPackage.getName(), ciClass.getName()});
            String simpleName = ciClass.getSimpleName();
            Preconditions.checkNotNull((Object)Strings.emptyToNull((String)simpleName), (String)"Could not get a typename for ci-class [%s]", (Object[])new Object[]{ciClass.getName()});
            return DescriptorRegistry.this.lookupType(prefix.value(), simpleName);
        }
    });
    private final DescriptorRegistryId id;

    protected DescriptorRegistry(DescriptorRegistryId id) {
        Preconditions.checkNotNull((Object)id, (Object)"The id of a DescriptorRegistry cannot be null.");
        this.id = id;
    }

    public static void add(DescriptorRegistry registry) {
        Preconditions.checkState((!REGISTRIES.containsKey(registry.id) ? 1 : 0) != 0, (String)"There is a DescriptorRegistry booted with id [%s]", (Object[])new Object[]{registry.id});
        if (registry.isLocal()) {
            DescriptorRegistryId otherLocal = DescriptorRegistry.lookupLocalRegistry();
            Preconditions.checkState((otherLocal == null ? 1 : 0) != 0, (String)"Tried to load another local DescriptorRegistry under [%s], already present under [%s]", (Object[])new Object[]{registry.id, otherLocal});
        }
        REGISTRIES.put(registry.id, registry);
    }

    private static DescriptorRegistryId lookupLocalRegistry() {
        for (DescriptorRegistry descriptorRegistry : REGISTRIES.values()) {
            if (!descriptorRegistry.isLocal()) continue;
            return descriptorRegistry.id;
        }
        return null;
    }

    public static void remove(DescriptorRegistryId id) {
        REGISTRIES.remove(id);
    }

    public static Collection<Descriptor> getDescriptors() {
        return DescriptorRegistry.getDefaultDescriptorRegistry()._getDescriptors();
    }

    static DescriptorRegistry getDefaultDescriptorRegistry() {
        Preconditions.checkState((!REGISTRIES.keySet().isEmpty() ? 1 : 0) != 0, (Object)"No DescriptorRegistries have been loaded.");
        DescriptorRegistryId defaultRegistryId = DescriptorRegistry.lookupLocalRegistry();
        if (defaultRegistryId != null) {
            return DescriptorRegistry.getDescriptorRegistry(defaultRegistryId);
        }
        return REGISTRIES.values().iterator().next();
    }

    public static Collection<Type> getSubtypes(Type supertype) {
        return DescriptorRegistry.getDescriptorRegistry(supertype)._getSubtypes(supertype);
    }

    public static Descriptor getDescriptor(String prefixedName) {
        return DescriptorRegistry.getDescriptor(Type.valueOf(prefixedName));
    }

    public static Descriptor getDescriptor(String prefix, String name) {
        return DescriptorRegistry.getDescriptor(Type.valueOf(prefix, name));
    }

    public static Descriptor getDescriptor(Type type) {
        return DescriptorRegistry.getDescriptorRegistry(type)._getDescriptor(type);
    }

    private static DescriptorRegistry getDescriptorRegistry(Type type) {
        return REGISTRIES.get(Preconditions.checkNotNull((Object)type.getTypeSource(), (String)"The type [%s] is not registered with any DescriptorRegistry", (Object[])new Object[]{type}));
    }

    public static boolean exists(Type type) {
        return DescriptorRegistry.getDescriptorRegistry(type)._exists(type);
    }

    protected static DescriptorRegistry getInstance() {
        return DescriptorRegistry.getDefaultDescriptorRegistry();
    }

    public static DescriptorRegistry getDescriptorRegistry(DescriptorRegistryId id) {
        return REGISTRIES.get(id);
    }

    public Type lookupType(Class<?> ciClass) {
        return (Type)this.CLASS_TYPE_CACHE.getUnchecked(ciClass);
    }

    public Type lookupType(String typeName) {
        return (Type)this.NAME_TYPE_CACHE.getUnchecked((Object)typeName);
    }

    public Type lookupType(String prefix, String simpleName) {
        return new Type(prefix, simpleName, this.id);
    }

    protected abstract boolean isLocal();

    protected abstract Collection<Descriptor> _getDescriptors();

    protected abstract Collection<Type> _getSubtypes(Type var1);

    protected abstract Descriptor _getDescriptor(Type var1);

    protected abstract boolean _exists(Type var1);
}

