/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.strings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.strings.InternalStringTermsFacet;
import org.elasticsearch.search.facet.terms.support.EntryPriorityQueue;
import org.elasticsearch.search.internal.SearchContext;

public class TermsStringOrdinalsFacetExecutor
extends FacetExecutor {
    private final IndexFieldData.WithOrdinals indexFieldData;
    final CacheRecycler cacheRecycler;
    final BigArrays bigArrays;
    private final TermsFacet.ComparatorType comparatorType;
    private final int size;
    private final int shardSize;
    private final int minCount;
    private final ImmutableSet<BytesRef> excluded;
    private final Matcher matcher;
    final int ordinalsCacheAbove;
    final List<ReaderAggregator> aggregators;
    long missing;
    long total;

    public TermsStringOrdinalsFacetExecutor(IndexFieldData.WithOrdinals indexFieldData, int size, int shardSize, TermsFacet.ComparatorType comparatorType, boolean allTerms, SearchContext context, ImmutableSet<BytesRef> excluded, Pattern pattern, int ordinalsCacheAbove) {
        this.indexFieldData = indexFieldData;
        this.size = size;
        this.shardSize = shardSize;
        this.comparatorType = comparatorType;
        this.ordinalsCacheAbove = ordinalsCacheAbove;
        this.excluded = excluded == null || excluded.isEmpty() ? null : excluded;
        this.matcher = pattern != null ? pattern.matcher("") : null;
        this.minCount = allTerms ? -1 : 0;
        this.cacheRecycler = context.cacheRecycler();
        this.bigArrays = context.bigArrays();
        this.aggregators = new ArrayList<ReaderAggregator>(context.searcher().getIndexReader().leaves().size());
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        ReaderAggregator agg;
        Object ordered;
        CharsRef spare = new CharsRef();
        AggregatorPriorityQueue queue = new AggregatorPriorityQueue(this.aggregators.size());
        for (ReaderAggregator aggregator : this.aggregators) {
            if (!aggregator.nextPosition()) continue;
            queue.add(aggregator);
        }
        if (this.shardSize < 5000) {
            ordered = new EntryPriorityQueue(this.shardSize, this.comparatorType.comparator());
            while (queue.size() > 0) {
                agg = (ReaderAggregator)queue.top();
                BytesRef value = agg.copyCurrent();
                int count = 0;
                do {
                    count += agg.counts.get(agg.position);
                    if (agg.nextPosition()) {
                        agg = (ReaderAggregator)queue.updateTop();
                        continue;
                    }
                    queue.pop();
                    agg = (ReaderAggregator)queue.top();
                } while (agg != null && value.equals((Object)agg.current));
                if (count <= this.minCount || this.excluded != null && this.excluded.contains(value)) continue;
                if (this.matcher != null) {
                    UnicodeUtil.UTF8toUTF16((BytesRef)value, (CharsRef)spare);
                    assert (spare.toString().equals(value.utf8ToString()));
                    if (!this.matcher.reset((CharSequence)spare).matches()) continue;
                }
                InternalStringTermsFacet.TermEntry entry = new InternalStringTermsFacet.TermEntry(value, count);
                ordered.insertWithOverflow((Object)entry);
            }
            InternalStringTermsFacet.TermEntry[] list = new InternalStringTermsFacet.TermEntry[ordered.size()];
            for (int i = ordered.size() - 1; i >= 0; --i) {
                list[i] = (InternalStringTermsFacet.TermEntry)ordered.pop();
            }
            Releasables.close(this.aggregators);
            return new InternalStringTermsFacet(facetName, this.comparatorType, this.size, Arrays.asList(list), this.missing, this.total);
        }
        ordered = new BoundedTreeSet<TermsFacet.Entry>(this.comparatorType.comparator(), this.shardSize);
        while (queue.size() > 0) {
            agg = (ReaderAggregator)queue.top();
            BytesRef value = agg.copyCurrent();
            int count = 0;
            do {
                count += agg.counts.get(agg.position);
                if (agg.nextPosition()) {
                    agg = (ReaderAggregator)queue.updateTop();
                    continue;
                }
                queue.pop();
                agg = (ReaderAggregator)queue.top();
            } while (agg != null && value.equals((Object)agg.current));
            if (count <= this.minCount || this.excluded != null && this.excluded.contains(value)) continue;
            if (this.matcher != null) {
                UnicodeUtil.UTF8toUTF16((BytesRef)value, (CharsRef)spare);
                assert (spare.toString().equals(value.utf8ToString()));
                if (!this.matcher.reset((CharSequence)spare).matches()) continue;
            }
            InternalStringTermsFacet.TermEntry entry = new InternalStringTermsFacet.TermEntry(value, count);
            ((BoundedTreeSet)ordered).add(entry);
        }
        Releasables.close(this.aggregators);
        return new InternalStringTermsFacet(facetName, this.comparatorType, this.size, (Collection<InternalStringTermsFacet.TermEntry>)ordered, this.missing, this.total);
    }

    public static class AggregatorPriorityQueue
    extends PriorityQueue<ReaderAggregator> {
        public AggregatorPriorityQueue(int size) {
            super(size);
        }

        protected boolean lessThan(ReaderAggregator a, ReaderAggregator b) {
            return a.current.compareTo(b.current) < 0;
        }
    }

    public final class ReaderAggregator
    implements Releasable {
        private final long maxOrd;
        final BytesValues.WithOrdinals values;
        final IntArray counts;
        int missing = 0;
        long position = -1L;
        BytesRef current;
        int total;

        public ReaderAggregator(BytesValues.WithOrdinals values, int ordinalsCacheLimit, CacheRecycler cacheRecycler) {
            this.values = values;
            this.maxOrd = values.getMaxOrd();
            this.counts = TermsStringOrdinalsFacetExecutor.this.bigArrays.newIntArray(this.maxOrd);
        }

        final void onOrdinal(int docId, long ordinal) {
            this.counts.increment(ordinal, 1);
            ++this.total;
        }

        final void incrementMissing(int numMissing) {
            this.missing += numMissing;
        }

        public boolean nextPosition() {
            if (++this.position >= this.maxOrd) {
                return false;
            }
            this.current = this.values.getValueByOrd(this.position);
            return true;
        }

        public BytesRef copyCurrent() {
            return BytesRef.deepCopyOf((BytesRef)this.current);
        }

        @Override
        public void close() {
            Releasables.close(this.counts);
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private long missing;
        private long total;
        private BytesValues.WithOrdinals values;
        private ReaderAggregator current;

        Collector() {
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            if (this.current != null) {
                this.missing += (long)this.current.missing;
                this.total += (long)this.current.total;
                if (this.current.values.getMaxOrd() > 0L) {
                    TermsStringOrdinalsFacetExecutor.this.aggregators.add(this.current);
                } else {
                    Releasables.close(this.current);
                }
            }
            this.values = TermsStringOrdinalsFacetExecutor.this.indexFieldData.load(context).getBytesValues();
            this.current = new ReaderAggregator(this.values, TermsStringOrdinalsFacetExecutor.this.ordinalsCacheAbove, TermsStringOrdinalsFacetExecutor.this.cacheRecycler);
        }

        public void collect(int doc) throws IOException {
            int length = this.values.setDocument(doc);
            int missing = 1;
            for (int i = 0; i < length; ++i) {
                this.current.onOrdinal(doc, this.values.nextOrd());
                missing = 0;
            }
            this.current.incrementMissing(missing);
        }

        @Override
        public void postCollection() {
            if (this.current != null) {
                this.missing += (long)this.current.missing;
                this.total += (long)this.current.total;
                if (this.current.values.getMaxOrd() > 0L) {
                    TermsStringOrdinalsFacetExecutor.this.aggregators.add(this.current);
                } else {
                    Releasables.close(this.current);
                }
                this.current = null;
            }
            TermsStringOrdinalsFacetExecutor.this.missing = this.missing;
            TermsStringOrdinalsFacetExecutor.this.total = this.total;
        }
    }
}

