/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.elasticsearch.Version;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotState;

public class BlobStoreSnapshot
implements Snapshot {
    private final String name;
    private final Version version;
    private final SnapshotState state;
    private final String reason;
    private final ImmutableList<String> indices;
    private final long startTime;
    private final long endTime;
    private final int totalShard;
    private final int successfulShards;
    private final ImmutableList<SnapshotShardFailure> shardFailures;

    private BlobStoreSnapshot(String name, ImmutableList<String> indices, SnapshotState state, String reason, Version version, long startTime, long endTime, int totalShard, int successfulShards, ImmutableList<SnapshotShardFailure> shardFailures) {
        assert (name != null);
        assert (indices != null);
        assert (state != null);
        assert (shardFailures != null);
        this.name = name;
        this.indices = indices;
        this.state = state;
        this.reason = reason;
        this.version = version;
        this.startTime = startTime;
        this.endTime = endTime;
        this.totalShard = totalShard;
        this.successfulShards = successfulShards;
        this.shardFailures = shardFailures;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public SnapshotState state() {
        return this.state;
    }

    @Override
    public String reason() {
        return this.reason;
    }

    @Override
    public Version version() {
        return this.version;
    }

    @Override
    public ImmutableList<String> indices() {
        return this.indices;
    }

    @Override
    public long startTime() {
        return this.startTime;
    }

    @Override
    public long endTime() {
        return this.endTime;
    }

    @Override
    public int totalShard() {
        return this.totalShard;
    }

    @Override
    public int successfulShards() {
        return this.successfulShards;
    }

    @Override
    public ImmutableList<SnapshotShardFailure> shardFailures() {
        return this.shardFailures;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public int compareTo(Snapshot o) {
        return Long.compare(this.startTime, ((BlobStoreSnapshot)o).startTime);
    }

    public static class Builder {
        private String name;
        private Version version = Version.CURRENT;
        private SnapshotState state = SnapshotState.IN_PROGRESS;
        private String reason;
        private ImmutableList<String> indices;
        private long startTime;
        private long endTime;
        private int totalShard;
        private int successfulShards;
        private ImmutableList<SnapshotShardFailure> shardFailures = ImmutableList.of();

        public Builder snapshot(BlobStoreSnapshot snapshot) {
            this.name = snapshot.name();
            this.indices = snapshot.indices();
            this.version = snapshot.version();
            this.reason = snapshot.reason();
            this.state = snapshot.state();
            this.startTime = snapshot.startTime();
            this.endTime = snapshot.endTime();
            this.totalShard = snapshot.totalShard();
            this.successfulShards = snapshot.successfulShards();
            this.shardFailures = snapshot.shardFailures();
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder indices(Collection<String> indices) {
            this.indices = ImmutableList.copyOf(indices);
            return this;
        }

        public Builder indices(String[] indices) {
            this.indices = ImmutableList.copyOf(indices);
            return this;
        }

        public Builder state(SnapshotState state) {
            this.state = state;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder success() {
            this.state = SnapshotState.SUCCESS;
            return this;
        }

        public Builder partial() {
            this.state = SnapshotState.PARTIAL;
            return this;
        }

        public Builder failed(String reason) {
            this.state = SnapshotState.FAILED;
            this.reason = reason;
            return this;
        }

        public Builder version(Version version) {
            this.version = version;
            return this;
        }

        public Builder startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder endTime(long endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder totalShard(int totalShard) {
            this.totalShard = totalShard;
            return this;
        }

        public Builder successfulShards(int successfulShards) {
            this.successfulShards = successfulShards;
            return this;
        }

        public Builder shardFailures(ImmutableList<SnapshotShardFailure> shardFailures) {
            this.shardFailures = shardFailures;
            return this;
        }

        public Builder failures(int totalShard, ImmutableList<SnapshotShardFailure> shardFailures) {
            this.totalShard = totalShard;
            this.successfulShards = totalShard - shardFailures.size();
            this.shardFailures = shardFailures;
            return this;
        }

        public BlobStoreSnapshot build() {
            return new BlobStoreSnapshot(this.name, this.indices, this.state, this.reason, this.version, this.startTime, this.endTime, this.totalShard, this.successfulShards, this.shardFailures);
        }

        public static void toXContent(BlobStoreSnapshot snapshot, XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(Fields.SNAPSHOT);
            builder.field(Fields.NAME, snapshot.name);
            builder.field(Fields.VERSION_ID, ((BlobStoreSnapshot)snapshot).version.id);
            builder.startArray(Fields.INDICES);
            for (String index : snapshot.indices) {
                builder.value(index);
            }
            builder.endArray();
            builder.field(Fields.STATE, (Object)snapshot.state);
            if (snapshot.reason != null) {
                builder.field(Fields.REASON, snapshot.reason);
            }
            builder.field(Fields.START_TIME, snapshot.startTime);
            builder.field(Fields.END_TIME, snapshot.endTime);
            builder.field(Fields.TOTAL_SHARDS, snapshot.totalShard);
            builder.field(Fields.SUCCESSFUL_SHARDS, snapshot.successfulShards);
            builder.startArray(Fields.FAILURES);
            for (SnapshotShardFailure shardFailure : snapshot.shardFailures) {
                SnapshotShardFailure.toXContent(shardFailure, builder, params);
            }
            builder.endArray();
            builder.endObject();
        }

        public static BlobStoreSnapshot fromXContent(XContentParser parser) throws IOException {
            String currentFieldName;
            Builder builder = new Builder();
            XContentParser.Token token = parser.currentToken();
            if (token == XContentParser.Token.START_OBJECT && "snapshot".equals(currentFieldName = parser.currentName())) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token != XContentParser.Token.FIELD_NAME) continue;
                    currentFieldName = parser.currentName();
                    token = parser.nextToken();
                    if (token.isValue()) {
                        if ("name".equals(currentFieldName)) {
                            builder.name(parser.text());
                            continue;
                        }
                        if ("state".equals(currentFieldName)) {
                            builder.state(SnapshotState.valueOf(parser.text()));
                            continue;
                        }
                        if ("reason".equals(currentFieldName)) {
                            builder.reason(parser.text());
                            continue;
                        }
                        if ("start_time".equals(currentFieldName)) {
                            builder.startTime(parser.longValue());
                            continue;
                        }
                        if ("end_time".equals(currentFieldName)) {
                            builder.endTime(parser.longValue());
                            continue;
                        }
                        if ("total_shards".equals(currentFieldName)) {
                            builder.totalShard(parser.intValue());
                            continue;
                        }
                        if ("successful_shards".equals(currentFieldName)) {
                            builder.successfulShards(parser.intValue());
                            continue;
                        }
                        if (!"version_id".equals(currentFieldName)) continue;
                        builder.version(Version.fromId(parser.intValue()));
                        continue;
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        if ("indices".equals(currentFieldName)) {
                            ArrayList<String> indices = new ArrayList<String>();
                            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                indices.add(parser.text());
                            }
                            builder.indices(indices);
                            continue;
                        }
                        if ("failures".equals(currentFieldName)) {
                            ArrayList<SnapshotShardFailure> failures = new ArrayList<SnapshotShardFailure>();
                            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                failures.add(SnapshotShardFailure.fromXContent(parser));
                            }
                            builder.shardFailures(ImmutableList.copyOf(failures));
                            continue;
                        }
                        parser.skipChildren();
                        continue;
                    }
                    if (token != XContentParser.Token.START_OBJECT) continue;
                    parser.skipChildren();
                }
            }
            return builder.build();
        }

        static final class Fields {
            static final XContentBuilderString SNAPSHOT = new XContentBuilderString("snapshot");
            static final XContentBuilderString NAME = new XContentBuilderString("name");
            static final XContentBuilderString VERSION_ID = new XContentBuilderString("version_id");
            static final XContentBuilderString INDICES = new XContentBuilderString("indices");
            static final XContentBuilderString STATE = new XContentBuilderString("state");
            static final XContentBuilderString REASON = new XContentBuilderString("reason");
            static final XContentBuilderString START_TIME = new XContentBuilderString("start_time");
            static final XContentBuilderString END_TIME = new XContentBuilderString("end_time");
            static final XContentBuilderString TOTAL_SHARDS = new XContentBuilderString("total_shards");
            static final XContentBuilderString SUCCESSFUL_SHARDS = new XContentBuilderString("successful_shards");
            static final XContentBuilderString FAILURES = new XContentBuilderString("failures");

            Fields() {
            }
        }
    }
}

