/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.optimizers;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.mvel2.optimizers.AccessorOptimizer;
import org.elasticsearch.common.mvel2.optimizers.dynamic.DynamicOptimizer;
import org.elasticsearch.common.mvel2.optimizers.impl.asm.ASMAccessorOptimizer;
import org.elasticsearch.common.mvel2.optimizers.impl.refl.ReflectiveAccessorOptimizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizerFactory {
    public static String DYNAMIC = "dynamic";
    public static String SAFE_REFLECTIVE = "reflective";
    private static String defaultOptimizer;
    private static final Map<String, AccessorOptimizer> accessorCompilers;
    private static ThreadLocal<Class<? extends AccessorOptimizer>> threadOptimizer;

    public static AccessorOptimizer getDefaultAccessorCompiler() {
        try {
            return (AccessorOptimizer)accessorCompilers.get(defaultOptimizer).getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("unable to instantiate accessor compiler", e);
        }
    }

    public static AccessorOptimizer getAccessorCompiler(String name) {
        try {
            return (AccessorOptimizer)accessorCompilers.get(name).getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("unable to instantiate accessor compiler", e);
        }
    }

    public static AccessorOptimizer getThreadAccessorOptimizer() {
        if (threadOptimizer.get() == null) {
            threadOptimizer.set(OptimizerFactory.getDefaultAccessorCompiler().getClass());
        }
        try {
            return threadOptimizer.get().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("unable to instantiate accessor compiler", e);
        }
    }

    public static void setThreadAccessorOptimizer(Class<? extends AccessorOptimizer> optimizer) {
        if (optimizer == null) {
            throw new RuntimeException("null optimizer");
        }
        threadOptimizer.set(optimizer);
    }

    public static void setDefaultOptimizer(String name) {
        try {
            defaultOptimizer = name;
            AccessorOptimizer ao = accessorCompilers.get(defaultOptimizer);
            ao.init();
            threadOptimizer.set(null);
        }
        catch (Exception e) {
            throw new RuntimeException("unable to instantiate accessor compiler", e);
        }
    }

    public static void clearThreadAccessorOptimizer() {
        threadOptimizer.set(null);
        threadOptimizer.remove();
    }

    public static boolean isThreadAccessorOptimizerInitialized() {
        return threadOptimizer.get() != null;
    }

    static {
        accessorCompilers = new HashMap<String, AccessorOptimizer>();
        threadOptimizer = new ThreadLocal();
        accessorCompilers.put(SAFE_REFLECTIVE, new ReflectiveAccessorOptimizer());
        accessorCompilers.put(DYNAMIC, new DynamicOptimizer());
        try {
            OptimizerFactory.class.getClassLoader().loadClass("org.elasticsearch.common.mvel2.asm.ClassWriter");
            accessorCompilers.put("ASM", new ASMAccessorOptimizer());
        }
        catch (ClassNotFoundException e) {
            defaultOptimizer = SAFE_REFLECTIVE;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("[MVEL] Notice: Possible incorrect version of ASM present (3.0 required).  Disabling JIT compiler.  Reflective Optimizer will be used.");
            defaultOptimizer = SAFE_REFLECTIVE;
        }
        if (Boolean.getBoolean("mvel2.disable.jit")) {
            OptimizerFactory.setDefaultOptimizer(SAFE_REFLECTIVE);
        } else {
            OptimizerFactory.setDefaultOptimizer(DYNAMIC);
        }
    }
}

