/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import java.util.EnumSet;
import java.util.HashSet;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Strings;

public class ParseField {
    private final String camelCaseName;
    private final String underscoreName;
    private final String[] deprecatedNames;
    public static final EnumSet<Flag> EMPTY_FLAGS = EnumSet.noneOf(Flag.class);

    public ParseField(String value, String ... deprecatedNames) {
        this.camelCaseName = Strings.toCamelCase(value);
        this.underscoreName = Strings.toUnderscoreCase(value);
        if (deprecatedNames == null || deprecatedNames.length == 0) {
            this.deprecatedNames = Strings.EMPTY_ARRAY;
        } else {
            HashSet<String> set = new HashSet<String>();
            for (String depName : deprecatedNames) {
                set.add(Strings.toCamelCase(depName));
                set.add(Strings.toUnderscoreCase(depName));
            }
            this.deprecatedNames = set.toArray(new String[0]);
        }
    }

    public String getPreferredName() {
        return this.underscoreName;
    }

    public String[] getAllNamesIncludedDeprecated() {
        String[] allNames = new String[2 + this.deprecatedNames.length];
        allNames[0] = this.camelCaseName;
        allNames[1] = this.underscoreName;
        for (int i = 0; i < this.deprecatedNames.length; ++i) {
            allNames[i + 2] = this.deprecatedNames[i];
        }
        return allNames;
    }

    public ParseField withDeprecation(String ... deprecatedNames) {
        return new ParseField(this.underscoreName, deprecatedNames);
    }

    public boolean match(String currentFieldName) {
        return this.match(currentFieldName, EMPTY_FLAGS);
    }

    public boolean match(String currentFieldName, EnumSet<Flag> flags) {
        if (currentFieldName.equals(this.camelCaseName) || currentFieldName.equals(this.underscoreName)) {
            return true;
        }
        for (String depName : this.deprecatedNames) {
            if (!currentFieldName.equals(depName)) continue;
            if (flags.contains((Object)Flag.STRICT)) {
                throw new ElasticsearchIllegalArgumentException("Deprecated field [" + currentFieldName + "] used expected [" + this.underscoreName + "] instead");
            }
            return true;
        }
        return false;
    }

    public static enum Flag {
        STRICT;

    }
}

