/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.replication.IndexReplicationOperationRequest;
import org.elasticsearch.action.support.replication.IndicesReplicationOperationRequest;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.action.support.replication.TransportIndexReplicationOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportIndicesReplicationOperationAction<Request extends IndicesReplicationOperationRequest, Response extends ActionResponse, IndexRequest extends IndexReplicationOperationRequest, IndexResponse extends ActionResponse, ShardRequest extends ShardReplicationOperationRequest, ShardReplicaRequest extends ShardReplicationOperationRequest, ShardResponse extends ActionResponse>
extends TransportAction<Request, Response> {
    protected final ClusterService clusterService;
    protected final TransportIndexReplicationOperationAction<IndexRequest, IndexResponse, ShardRequest, ShardReplicaRequest, ShardResponse> indexAction;

    protected TransportIndicesReplicationOperationAction(Settings settings, String actionName, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, TransportIndexReplicationOperationAction<IndexRequest, IndexResponse, ShardRequest, ShardReplicaRequest, ShardResponse> indexAction) {
        super(settings, actionName, threadPool);
        this.clusterService = clusterService;
        this.indexAction = indexAction;
        transportService.registerHandler(actionName, new TransportHandler());
    }

    protected abstract Map<String, Set<String>> resolveRouting(ClusterState var1, Request var2) throws ElasticsearchException;

    @Override
    protected void doExecute(Request request, final ActionListener<Response> listener) {
        ClusterState clusterState = this.clusterService.state();
        ClusterBlockException blockException = this.checkGlobalBlock(clusterState, request);
        if (blockException != null) {
            throw blockException;
        }
        String[] concreteIndices = clusterState.metaData().concreteIndices(((IndicesReplicationOperationRequest)request).indicesOptions(), ((IndicesReplicationOperationRequest)request).indices());
        blockException = this.checkRequestBlock(clusterState, request, concreteIndices);
        if (blockException != null) {
            throw blockException;
        }
        final AtomicInteger indexCounter = new AtomicInteger();
        final AtomicInteger completionCounter = new AtomicInteger(concreteIndices.length);
        final AtomicReferenceArray indexResponses = new AtomicReferenceArray(concreteIndices.length);
        long startTimeInMillis = System.currentTimeMillis();
        Map<String, Set<String>> routingMap = this.resolveRouting(clusterState, request);
        if (concreteIndices.length == 0) {
            listener.onResponse(this.newResponseInstance(request, indexResponses));
        } else {
            for (String index : concreteIndices) {
                Set<String> routing = null;
                if (routingMap != null) {
                    routing = routingMap.get(index);
                }
                IndexRequest indexRequest = this.newIndexRequestInstance(request, index, routing, startTimeInMillis);
                ((ActionRequest)indexRequest).listenerThreaded(false);
                this.indexAction.execute(indexRequest, new ActionListener<IndexResponse>((IndicesReplicationOperationRequest)request){
                    final /* synthetic */ IndicesReplicationOperationRequest val$request;
                    {
                        this.val$request = indicesReplicationOperationRequest;
                    }

                    @Override
                    public void onResponse(IndexResponse result) {
                        indexResponses.set(indexCounter.getAndIncrement(), result);
                        if (completionCounter.decrementAndGet() == 0) {
                            listener.onResponse(TransportIndicesReplicationOperationAction.this.newResponseInstance(this.val$request, indexResponses));
                        }
                    }

                    @Override
                    public void onFailure(Throwable e) {
                        int index = indexCounter.getAndIncrement();
                        if (TransportIndicesReplicationOperationAction.this.accumulateExceptions()) {
                            indexResponses.set(index, e);
                        }
                        if (completionCounter.decrementAndGet() == 0) {
                            listener.onResponse(TransportIndicesReplicationOperationAction.this.newResponseInstance(this.val$request, indexResponses));
                        }
                    }
                });
            }
        }
    }

    protected abstract Request newRequestInstance();

    protected abstract Response newResponseInstance(Request var1, AtomicReferenceArray var2);

    protected abstract IndexRequest newIndexRequestInstance(Request var1, String var2, Set<String> var3, long var4);

    protected abstract boolean accumulateExceptions();

    protected abstract ClusterBlockException checkGlobalBlock(ClusterState var1, Request var2);

    protected abstract ClusterBlockException checkRequestBlock(ClusterState var1, Request var2, String[] var3);

    private class TransportHandler
    extends BaseTransportRequestHandler<Request> {
        private TransportHandler() {
        }

        @Override
        public Request newInstance() {
            return TransportIndicesReplicationOperationAction.this.newRequestInstance();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            ((ActionRequest)request).listenerThreaded(false);
            TransportIndicesReplicationOperationAction.this.execute(request, new ActionListener<Response>((IndicesReplicationOperationRequest)request){
                final /* synthetic */ IndicesReplicationOperationRequest val$request;
                {
                    this.val$request = indicesReplicationOperationRequest;
                }

                @Override
                public void onResponse(Response result) {
                    try {
                        channel.sendResponse((TransportResponse)result);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportIndicesReplicationOperationAction.this.logger.warn("Failed to send error response for action [" + TransportIndicesReplicationOperationAction.this.actionName + "] and request [" + this.val$request + "]", e1, new Object[0]);
                    }
                }
            });
        }
    }
}

