/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.storage.file.PackIndexWriterV1;
import org.eclipse.jgit.storage.file.PackIndexWriterV2;
import org.eclipse.jgit.transport.PackedObjectInfo;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.io.SafeBufferedOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PackIndexWriter {
    protected static final byte[] TOC = new byte[]{-1, 116, 79, 99};
    protected final DigestOutputStream out;
    protected final byte[] tmp;
    protected List<? extends PackedObjectInfo> entries;
    protected byte[] packChecksum;

    public static PackIndexWriter createOldestPossible(OutputStream dst, List<? extends PackedObjectInfo> objs) {
        int version = 1;
        block4: for (PackedObjectInfo packedObjectInfo : objs) {
            switch (version) {
                case 1: {
                    if (PackIndexWriterV1.canStore(packedObjectInfo)) continue block4;
                    version = 2;
                }
                case 2: {
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        return PackIndexWriter.createVersion(dst, version);
    }

    public static PackIndexWriter createVersion(OutputStream dst, int version) {
        switch (version) {
            case 1: {
                return new PackIndexWriterV1(dst);
            }
            case 2: {
                return new PackIndexWriterV2(dst);
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(JGitText.get().unsupportedPackIndexVersion, version));
    }

    protected PackIndexWriter(OutputStream dst) {
        this.out = new DigestOutputStream(dst instanceof BufferedOutputStream ? dst : new SafeBufferedOutputStream(dst), Constants.newMessageDigest());
        this.tmp = new byte[24];
    }

    public void write(List<? extends PackedObjectInfo> toStore, byte[] packDataChecksum) throws IOException {
        this.entries = toStore;
        this.packChecksum = packDataChecksum;
        this.writeImpl();
        this.out.flush();
    }

    protected abstract void writeImpl() throws IOException;

    protected void writeTOC(int version) throws IOException {
        this.out.write(TOC);
        NB.encodeInt32(this.tmp, 0, version);
        this.out.write(this.tmp, 0, 4);
    }

    protected void writeFanOutTable() throws IOException {
        int[] fanout = new int[256];
        for (PackedObjectInfo packedObjectInfo : this.entries) {
            int n = packedObjectInfo.getFirstByte() & 0xFF;
            fanout[n] = fanout[n] + 1;
        }
        for (int i = 1; i < 256; ++i) {
            int n = i;
            fanout[n] = fanout[n] + fanout[i - 1];
        }
        for (int n : fanout) {
            NB.encodeInt32(this.tmp, 0, n);
            this.out.write(this.tmp, 0, 4);
        }
    }

    protected void writeChecksumFooter() throws IOException {
        this.out.write(this.packChecksum);
        this.out.on(false);
        this.out.write(this.out.getMessageDigest().digest());
    }
}

